/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.framework.AbstractUpdatesRequest;
import com.openexchange.ajax.infostore.actions.AllInfostoreRequest;
import com.openexchange.ajax.infostore.actions.DetachInfostoreRequest;
import com.openexchange.ajax.infostore.actions.DetachInfostoreResponse;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.infostore.actions.UpdatesInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdatesInfostoreResponse;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.java.util.UUIDs;
import com.openexchange.test.FolderTestManager;
import com.openexchange.test.TestInit;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import org.json.JSONArray;
import org.junit.Test;

public class UpdatesTest
extends AbstractAJAXSession {
    protected static final int[] virtualFolders = new int[]{9, 14, 15};
    private FolderTestManager ftm;
    private FolderObject testFolder;
    private com.openexchange.file.storage.File knowledgeDoc;
    private com.openexchange.file.storage.File urlDoc;
    private InfostoreTestManager itm;

    public UpdatesTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.itm = new InfostoreTestManager(this.client);
        this.ftm = new FolderTestManager(this.client);
        this.testFolder = this.ftm.generatePrivateFolder(UUIDs.getUnformattedString((UUID)UUID.randomUUID()), 8, this.client.getValues().getPrivateInfostoreFolder(), this.client.getValues().getUserId());
        this.ftm.insertFolderOnServer(this.testFolder);
        this.knowledgeDoc = new DefaultFile();
        this.knowledgeDoc.setFolderId(String.valueOf(this.testFolder.getObjectID()));
        this.knowledgeDoc.setTitle("test knowledge");
        this.knowledgeDoc.setDescription("test knowledge description");
        this.itm.newAction(this.knowledgeDoc);
        this.urlDoc = new DefaultFile();
        this.urlDoc.setFolderId(String.valueOf(this.testFolder.getObjectID()));
        this.urlDoc.setTitle("test url");
        this.urlDoc.setDescription("test url description");
        this.urlDoc.setURL("http://www.open-xchange.com");
        this.itm.newAction(this.urlDoc);
    }

    @Override
    public void tearDown() throws Exception {
        this.itm.cleanUp();
        this.ftm.cleanUp();
        super.tearDown();
    }

    public void testBasic() throws Exception {
        AllInfostoreRequest allReq = new AllInfostoreRequest(this.testFolder.getObjectID(), new int[]{1, 20}, 1, Order.ASCENDING);
        AbstractColumnsResponse allResp = this.client.execute(allReq);
        Date timestamp = new Date(allResp.getTimestamp().getTime() + 2L);
        DefaultFile updateDoc = new DefaultFile();
        updateDoc.setId(this.knowledgeDoc.getId());
        updateDoc.setTitle("test knowledge updated");
        this.itm.updateAction((com.openexchange.file.storage.File)updateDoc, new File.Field[]{File.Field.TITLE}, timestamp);
        UpdatesInfostoreRequest req = new UpdatesInfostoreRequest(this.testFolder.getObjectID(), new int[]{1, 700}, 1, Order.ASCENDING, AbstractUpdatesRequest.Ignore.NONE, timestamp, true);
        UpdatesInfostoreResponse resp = this.client.execute(req);
        JSONArray modifiedValues = resp.getNewAndModified().iterator().next();
        UpdatesTest.assertEquals((String)"Wrong number of modified documents", (int)1, (int)resp.getNewAndModified().size());
        UpdatesTest.assertEquals((String)"Wrong number of deleted documents", (int)0, (int)resp.getDeleted().size());
        UpdatesTest.assertEquals((String)"Wrong document id", (String)updateDoc.getId(), (String)modifiedValues.getString(0));
        UpdatesTest.assertEquals((String)"Wrong document title", (String)updateDoc.getTitle(), (String)modifiedValues.getString(1));
        timestamp = this.itm.getLastResponse().getTimestamp();
        this.itm.deleteAction(this.knowledgeDoc.getId(), String.valueOf(this.testFolder.getObjectID()), timestamp);
        this.itm.deleteAction(this.urlDoc.getId(), String.valueOf(this.testFolder.getObjectID()), timestamp);
        req = new UpdatesInfostoreRequest(this.testFolder.getObjectID(), new int[]{1}, 1, Order.ASCENDING, AbstractUpdatesRequest.Ignore.NONE, timestamp, true);
        resp = this.client.execute(req);
        UpdatesTest.assertEquals((String)"Wrong number of modified documents", (int)0, (int)resp.getNewAndModified().size());
        UpdatesTest.assertEquals((String)"Wrong number of deleted documents", (int)2, (int)resp.getDeleted().size());
        int found = 0;
        for (String id : resp.getDeleted()) {
            if (!id.equals(String.valueOf(this.knowledgeDoc.getId())) && !id.equals(String.valueOf(this.urlDoc.getId()))) continue;
            ++found;
        }
        UpdatesTest.assertEquals((String)"Wrong documents have been deleted", (int)2, (int)found);
    }

    public void testRemovedVersionForcesUpdate() throws Exception {
        AllInfostoreRequest allReq = new AllInfostoreRequest(this.testFolder.getObjectID(), new int[]{1, 20}, 1, Order.ASCENDING);
        AbstractColumnsResponse allResp = this.client.execute(allReq);
        Date timestamp = new Date(allResp.getTimestamp().getTime() + 2L);
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        DefaultFile updateDoc = new DefaultFile();
        updateDoc.setId(this.knowledgeDoc.getId());
        updateDoc.setVersionComment("Comment 1");
        this.itm.updateAction((com.openexchange.file.storage.File)updateDoc, upload, new File.Field[]{File.Field.VERSION_COMMENT}, timestamp);
        timestamp = this.itm.getLastResponse().getTimestamp();
        updateDoc.setVersionComment("Comment 2");
        this.itm.updateAction((com.openexchange.file.storage.File)updateDoc, upload, new File.Field[]{File.Field.VERSION_COMMENT}, timestamp);
        timestamp = this.itm.getLastResponse().getTimestamp();
        updateDoc.setVersionComment("Comment 3");
        this.itm.updateAction((com.openexchange.file.storage.File)updateDoc, upload, new File.Field[]{File.Field.VERSION_COMMENT}, timestamp);
        timestamp = this.itm.getLastResponse().getTimestamp();
        DetachInfostoreRequest detachReq = new DetachInfostoreRequest(updateDoc.getId(), this.testFolder.getObjectID(), Collections.singleton("3"), timestamp);
        DetachInfostoreResponse detachResp = this.client.execute(detachReq);
        UpdatesTest.assertEquals((String)"Version was not deleted", (int)0, (int)detachResp.getNotDeleted().length);
        UpdatesInfostoreRequest req = new UpdatesInfostoreRequest(this.testFolder.getObjectID(), new int[]{700, 706}, 1, Order.ASCENDING, AbstractUpdatesRequest.Ignore.NONE, timestamp, true);
        UpdatesInfostoreResponse resp = this.client.execute(req);
        UpdatesTest.assertEquals((String)"Wrong number of modified documents", (int)1, (int)resp.getNewAndModified().size());
    }

    public void testVirtualFolder() throws Exception {
        for (int folderId : virtualFolders) {
            this.virtualFolderTest(folderId);
        }
    }

    @Test
    public void virtualFolderTest(int folderId) throws Exception {
        UpdatesInfostoreRequest req = new UpdatesInfostoreRequest(folderId, new int[]{1}, 1, Order.ASCENDING, AbstractUpdatesRequest.Ignore.NONE, new Date(0L), true);
        UpdatesInfostoreResponse resp = this.client.execute(req);
        UpdatesTest.assertEquals((String)"Wrong number of modified documents", (int)0, (int)(resp.getNewAndModified().size() + resp.getDeleted().size()));
    }

    public void testLastModifiedUTC() throws Exception {
        UpdatesInfostoreRequest req = new UpdatesInfostoreRequest(this.testFolder.getObjectID(), new int[]{6}, 6, Order.ASCENDING, AbstractUpdatesRequest.Ignore.NONE, new Date(0L), true);
        UpdatesInfostoreResponse resp = this.client.execute(req);
        UpdatesTest.assertTrue((String)"Wrong number of modified documents", (resp.getNewAndModified().size() + resp.getDeleted().size() > 0 ? 1 : 0) != 0);
    }

    public void testNumberOfVersions() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        DefaultFile updateDoc = new DefaultFile();
        updateDoc.setId(this.knowledgeDoc.getId());
        updateDoc.setDescription("New description");
        this.itm.updateAction((com.openexchange.file.storage.File)updateDoc, upload, new File.Field[]{File.Field.DESCRIPTION}, new Date(Long.MAX_VALUE));
        UpdatesInfostoreRequest req = new UpdatesInfostoreRequest(this.testFolder.getObjectID(), new int[]{1, 711}, 1, Order.ASCENDING, AbstractUpdatesRequest.Ignore.NONE, new Date(0L), true);
        UpdatesInfostoreResponse resp = this.client.execute(req);
        boolean found = false;
        for (JSONArray modified : resp.getNewAndModified()) {
            String id = modified.getString(0);
            int numberOfVersions = modified.getInt(1);
            if (!id.equals(updateDoc.getId())) continue;
            UpdatesTest.assertEquals((int)1, (int)numberOfVersions);
            found = true;
        }
        UpdatesTest.assertTrue((boolean)found);
    }
}

