/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.config.ConfigTools;
import com.openexchange.ajax.container.Response;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.java.Charsets;
import com.openexchange.test.TestInit;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class LockTest
extends InfostoreAJAXTest {
    protected File testFile;
    private static final int[] mapping = new int[]{0, -1, 1, -1, 2, -1, -1, -1, 4};
    private static final String FOLDER_URL = "/ajax/folders";

    public LockTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        this.testFile = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        this.sessionId = this.getSessionId();
        int userId = ConfigTools.getUserId(this.getWebConversation(), this.getHostName(), this.getSessionId());
        int secondUserId = ConfigTools.getUserId(this.getSecondWebConversation(), this.getHostName(), this.getSecondSessionId());
        FolderObject myInfostore = FolderTest.getMyInfostoreFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId);
        this.folderId = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, myInfostore.getObjectID(), "NewInfostoreFolder" + System.currentTimeMillis(), "infostore", 2, -1, true);
        LockTest.updateFolder(this.getWebConversation(), this.getHostName(), this.sessionId, userId, secondUserId, this.folderId, Long.MAX_VALUE);
        Map<String, String> create = this.m("folder_id", Integer.valueOf(this.folderId).toString(), "title", "test knowledge", "description", "test knowledge description");
        String c = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, create, this.testFile, "text/plain");
        this.clean.add(c);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, c, Long.MAX_VALUE, this.m(new String[0]), this.testFile, "text/plain");
        LockTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, c, Long.MAX_VALUE, this.m(new String[0]), this.testFile, "text/plain");
        LockTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, c, Long.MAX_VALUE, this.m(new String[0]), this.testFile, "text/plain");
        LockTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, c, Long.MAX_VALUE, this.m(new String[0]), this.testFile, "text/plain");
        LockTest.assertNoError(res);
    }

    @Override
    public void tearDown() throws Exception {
        FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.sessionId, new int[]{this.folderId}, Long.MAX_VALUE, false);
        super.tearDown();
    }

    public void testLock() throws Exception {
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        Date ts = res.getTimestamp();
        res = this.lock(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        LockTest.assertNoError(res);
        LockTest.assertNotNull((Object)res.getTimestamp());
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        LockTest.assertNoError(res);
        LockTest.assertLocked((JSONObject)res.getData());
        res = this.updates(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{1}, ts.getTime());
        JSONArray modAndDel = (JSONArray)res.getData();
        JSONArray mod = modAndDel.getJSONArray(0);
        LockTest.assertEquals((int)1, (int)mod.length());
        LockTest.assertEquals((String)((String)this.clean.get(0)), (String)mod.getString(0));
        String sessionId2 = this.getSecondSessionId();
        res = this.update(this.getSecondWebConversation(), this.getHostName(), sessionId2, (String)this.clean.get(0), Long.MAX_VALUE, this.m("title", "Hallo"));
        LockTest.assertTrue((boolean)res.hasError());
        int userId2 = FolderTest.getUserId(this.getSecondWebConversation(), this.getHostName(), this.getSeconduser(), this.getPassword());
        int folderId2 = FolderTest.getMyInfostoreFolder(this.getSecondWebConversation(), this.getHostName(), sessionId2, userId2).getObjectID();
        res = this.update(this.getSecondWebConversation(), this.getHostName(), sessionId2, (String)this.clean.get(0), Long.MAX_VALUE, this.m("folder_id", "" + folderId2));
        LockTest.assertTrue((boolean)res.hasError());
        JSONObject response = this.deleteGetResponse(this.getSecondWebConversation(), null, this.getHostName(), sessionId2, Long.MAX_VALUE, new String[][]{{String.valueOf(this.folderId), (String)this.clean.get(0)}});
        LockTest.assertTrue((boolean)response.has("error"));
        int[] notDetached = this.detach(this.getSecondWebConversation(), this.getHostName(), sessionId2, Long.MAX_VALUE, (String)this.clean.get(0), new int[]{4});
        LockTest.assertEquals((int)1, (int)notDetached.length);
        LockTest.assertEquals((int)4, (int)notDetached[0]);
        res = this.lock(this.getSecondWebConversation(), this.getHostName(), sessionId2, (String)this.clean.get(0));
        LockTest.assertTrue((boolean)res.hasError());
        res = this.unlock(this.getSecondWebConversation(), this.getHostName(), sessionId2, (String)this.clean.get(0));
        LockTest.assertTrue((boolean)res.hasError());
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("title", "Hallo"));
        LockTest.assertNoError(res);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        JSONObject o = (JSONObject)res.getData();
        LockTest.assertEquals((Object)"Hallo", (Object)o.get("title"));
        notDetached = this.detach(this.getWebConversation(), this.getHostName(), this.sessionId, Long.MAX_VALUE, (String)this.clean.get(0), new int[]{4});
        LockTest.assertEquals((int)0, (int)notDetached.length);
        String[] notDeleted = this.delete(this.getWebConversation(), this.getHostName(), this.sessionId, Long.MAX_VALUE, new String[][]{{String.valueOf(this.folderId), (String)this.clean.get(0)}});
        LockTest.assertEquals((int)0, (int)notDeleted.length);
        this.clean.remove(0);
    }

    public void testUnlock() throws Exception {
        Response res = this.lock(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        LockTest.assertNoError(res);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        LockTest.assertNoError(res);
        LockTest.assertLocked((JSONObject)res.getData());
        res = this.lock(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        LockTest.assertNoError(res);
        res = this.unlock(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        LockTest.assertNoError(res);
        LockTest.assertNotNull((Object)res.getTimestamp());
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        LockTest.assertNoError(res);
        LockTest.assertUnlocked((JSONObject)res.getData());
        String sessionId2 = this.getSecondSessionId();
        res = this.lock(this.getSecondWebConversation(), this.getHostName(), sessionId2, (String)this.clean.get(0));
        LockTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("title", "Hallo"));
        LockTest.assertTrue((boolean)res.hasError());
        res = this.unlock(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        LockTest.assertNoError(res);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        LockTest.assertNoError(res);
        LockTest.assertUnlocked((JSONObject)res.getData());
    }

    public static void assertLocked(JSONObject o) throws JSONException {
        long locked = o.getInt(Metadata.LOCKED_UNTIL_LITERAL.getName());
        LockTest.assertFalse((String)("This must be != 0: " + locked), (0L == locked ? 1 : 0) != 0);
    }

    public static void assertUnlocked(JSONObject o) throws JSONException {
        LockTest.assertEquals((int)0, (int)o.getInt(Metadata.LOCKED_UNTIL_LITERAL.getName()));
    }

    public static boolean updateFolder(WebConversation conversation, String hostname, String sessionId, int entity, int secondEntity, int folderId, long timestamp) throws JSONException, MalformedURLException, IOException, SAXException {
        JSONObject jsonFolder = new JSONObject();
        jsonFolder.put("id", folderId);
        JSONArray perms = new JSONArray();
        JSONObject jsonPermission = new JSONObject();
        jsonPermission.put("entity", entity);
        jsonPermission.put("group", false);
        jsonPermission.put("bits", LockTest.createPermissionBits(8, 8, 8, 8, true));
        perms.put((Object)jsonPermission);
        jsonPermission = new JSONObject();
        jsonPermission.put("entity", secondEntity);
        jsonPermission.put("group", false);
        jsonPermission.put("bits", LockTest.createPermissionBits(8, 8, 8, 8, true));
        perms.put((Object)jsonPermission);
        jsonFolder.put("permissions", (Object)perms);
        URLParameter urlParam = new URLParameter();
        urlParam.setParameter("action", "update");
        urlParam.setParameter("session", sessionId);
        urlParam.setParameter("id", String.valueOf(folderId));
        urlParam.setParameter("timestamp", String.valueOf(timestamp));
        byte[] bytes = jsonFolder.toString().getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + hostname + FOLDER_URL + urlParam.getURLParameters(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        JSONObject respObj = new JSONObject(resp.getText());
        return !respObj.has("error");
    }

    private static int createPermissionBits(int fp, int orp, int owp, int odp, boolean adminFlag) {
        int[] perms = new int[]{fp, orp, owp, odp, adminFlag ? 1 : 0};
        return LockTest.createPermissionBits(perms);
    }

    private static int createPermissionBits(int[] permission) {
        int retval = 0;
        boolean first = true;
        for (int i = permission.length - 1; i >= 0; --i) {
            int exponent = i * 7;
            if (first) {
                retval += permission[i] << exponent;
                first = false;
                continue;
            }
            if (permission[i] == 128) {
                retval += 64 << exponent;
                continue;
            }
            retval += mapping[permission[i]] << exponent;
        }
        return retval;
    }
}

