/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.realtime.json.fields.ResourceIDField;
import com.openexchange.test.OXTestToolkit;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class CopyTest
extends InfostoreAJAXTest {
    private final Set<String> skipKeys = new HashSet<String>(Arrays.asList(Metadata.ID_LITERAL.getName(), Metadata.CREATION_DATE_LITERAL.getName(), Metadata.LAST_MODIFIED_LITERAL.getName(), Metadata.LAST_MODIFIED_UTC_LITERAL.getName(), Metadata.VERSION_LITERAL.getName(), Metadata.CURRENT_VERSION_LITERAL.getName(), Metadata.SEQUENCE_NUMBER_LITERAL.getName(), Metadata.CONTENT_LITERAL.getName(), new ResourceIDField().getColumnName()));

    public CopyTest(String name) {
        super(name);
    }

    public void testCopy() throws Exception {
        String id = this.copy(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), String.valueOf(this.folderId), Long.MAX_VALUE, this.m(new String[0]));
        this.clean.add(id);
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        CopyTest.assertNoError(res);
        JSONObject orig = (JSONObject)res.getData();
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        CopyTest.assertNoError(res);
        JSONObject copy = (JSONObject)res.getData();
        CopyTest.assertEquals((int)orig.length(), (int)copy.length());
        Iterator keys = orig.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            if (this.skipKeys.contains(key)) continue;
            CopyTest.assertEquals((String)(key + " seems to have a wrong value"), (String)orig.get(key).toString(), (String)copy.get(key).toString());
        }
        CopyTest.assertNotNull((Object)res.getTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyFile() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        String id = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("folder_id", Integer.valueOf(this.folderId).toString(), "title", "test upload", "description", "test upload description"), upload, "text/plain");
        this.clean.add(id);
        String copyId = this.copy(this.getWebConversation(), this.getHostName(), this.sessionId, id, String.valueOf(this.folderId), Long.MAX_VALUE, this.m("filename", "other.properties"));
        this.clean.add(copyId);
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        CopyTest.assertNoError(res);
        JSONObject orig = (JSONObject)res.getData();
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, copyId);
        CopyTest.assertNoError(res);
        JSONObject copy = (JSONObject)res.getData();
        CopyTest.assertEquals((Object)"other.properties", (Object)copy.get("filename"));
        CopyTest.assertEquals((Object)orig.get("file_size"), (Object)copy.get("file_size"));
        CopyTest.assertEquals((Object)orig.get("file_mimetype"), (Object)copy.get("file_mimetype"));
        FileInputStream is = null;
        InputStream is2 = null;
        try {
            is = new FileInputStream(upload);
            is2 = this.document(this.getWebConversation(), this.getHostName(), this.sessionId, copyId, 1);
            OXTestToolkit.assertSameContent(is, is2);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (is2 != null) {
                is2.close();
            }
        }
    }

    public void testModifyingCopy() throws Exception {
        String id = this.copy(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), String.valueOf(this.folderId), Long.MAX_VALUE, this.m("title", "copy"));
        this.clean.add(id);
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        CopyTest.assertNoError(res);
        JSONObject orig = (JSONObject)res.getData();
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        CopyTest.assertNoError(res);
        JSONObject copy = (JSONObject)res.getData();
        CopyTest.assertEquals((int)orig.length(), (int)copy.length());
        Iterator keys = orig.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            if (!this.skipKeys.contains(key) && !key.equals("title")) {
                CopyTest.assertEquals((String)(key + " seems to have a wrong value"), (String)orig.get(key).toString(), (String)copy.get(key).toString());
                continue;
            }
            if (!key.equals("title")) continue;
            CopyTest.assertEquals((Object)"copy", (Object)copy.get(key));
        }
    }

    public void testUploadCopy() throws Exception {
        File upload = new File(TestInit.getTestProperty("webdavPropertiesFile"));
        String id = this.copy(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), String.valueOf(this.folderId), Long.MAX_VALUE, this.m("title", "copy"), upload, "text/plain");
        this.clean.add(id);
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        CopyTest.assertNoError(res);
        JSONObject copy = (JSONObject)res.getData();
        CopyTest.assertEquals((Object)upload.getName(), (Object)copy.get("filename"));
        CopyTest.assertEquals((Object)"text/plain", (Object)copy.get("file_mimetype"));
    }

    public void testVirtualFolder() throws Exception {
        for (int folderId : virtualFolders) {
            this.virtualFolderTest(folderId);
        }
    }

    public void virtualFolderTest(int folderId) throws Exception {
        try {
            String id = this.copy(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), String.valueOf(folderId), Long.MAX_VALUE, this.m("folder_id", "" + folderId));
            this.clean.add(id);
            CopyTest.fail((String)"Expected IOException");
        }
        catch (JSONException x) {
            CopyTest.assertTrue((String)x.getMessage(), (boolean)x.getMessage().contains("IFO-1700"));
        }
    }
}

