/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.importexport.actions.CSVExportRequest;
import com.openexchange.ajax.importexport.actions.CSVExportResponse;
import com.openexchange.ajax.importexport.actions.CSVImportRequest;
import com.openexchange.ajax.importexport.actions.CSVImportResponse;
import com.openexchange.groupware.container.Contact;
import java.io.ByteArrayInputStream;
import org.json.JSONArray;

public class Bug32200Test
extends AbstractManagedContactTest {
    public Bug32200Test(String name) {
        super(name);
    }

    public void testImportCategories() throws Exception {
        String categories = "Wichtig,Firma,Neu";
        String csv = "\"Sur name\",\"Given name\",\"Email 1\",\"Categories\"\n\"Walter\",\"Otto\",\"otto.walter@example.com\",\"" + categories + "\"\n";
        CSVImportRequest request = new CSVImportRequest(this.folderID, new ByteArrayInputStream(csv.getBytes()), false);
        CSVImportResponse response = this.getClient().execute(request);
        Bug32200Test.assertFalse((String)"response has error", (boolean)response.hasError());
        JSONArray data = (JSONArray)response.getData();
        Bug32200Test.assertNotNull((String)"got no data", (Object)data);
        Bug32200Test.assertEquals((int)1, (int)data.length());
        Contact contact = this.manager.getAction(this.folderID, data.getJSONObject(0).getInt("id"));
        Bug32200Test.assertNotNull((String)"imported contact not found", (Object)contact);
        Bug32200Test.assertNotNull((String)"no categories imported", (Object)contact.getCategories());
        Bug32200Test.assertEquals((String)"wrong categories imported", (String)categories, (String)contact.getCategories());
    }

    public void testExportCategories() throws Exception {
        String categories = "Unwichtig,Privat,Alt";
        Contact contact = this.generateContact(((Object)((Object)this)).getClass().getName());
        contact.setCategories(categories);
        this.manager.newAction(contact);
        CSVExportResponse csvExportResponse = this.client.execute(new CSVExportRequest(this.folderID));
        String csv = String.valueOf(csvExportResponse.getData());
        Bug32200Test.assertNotNull((String)"no data exported", (Object)csv);
        Bug32200Test.assertTrue((String)"categories not exported", (boolean)csv.contains(categories));
    }
}

