/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.importexport.actions.VCardExportRequest;
import com.openexchange.ajax.importexport.actions.VCardExportResponse;
import com.openexchange.ajax.importexport.actions.VCardImportRequest;
import com.openexchange.ajax.importexport.actions.VCardImportResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.test.ContactTestManager;
import java.io.ByteArrayInputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug27151Test_RoundtripOfYomiFields
extends AbstractManagedContactTest {
    private Contact contact;

    public Bug27151Test_RoundtripOfYomiFields(String name) {
        super(name);
    }

    public void testShouldImportXPhoneticAsYomiField() throws Exception, Exception, Exception {
        this.contact = ContactTestManager.generateFullContact(this.folderID);
        this.contact.setYomiFirstName("YomiFirstName1");
        this.contact.setYomiLastName("YomiLastName1");
        this.manager.newAction(this.contact);
        VCardExportResponse exportResponse = this.getClient().execute(new VCardExportRequest(this.folderID, true));
        String vCard = exportResponse.getVCard();
        Bug27151Test_RoundtripOfYomiFields.assertTrue((boolean)vCard.contains("X-PHONETIC-FIRST-NAME"));
        Bug27151Test_RoundtripOfYomiFields.assertTrue((boolean)vCard.contains("X-PHONETIC-LAST-NAME"));
        Bug27151Test_RoundtripOfYomiFields.assertTrue((boolean)vCard.contains("YomiFirstName1"));
        Bug27151Test_RoundtripOfYomiFields.assertTrue((boolean)vCard.contains("YomiLastName1"));
        this.manager.deleteAction(this.contact);
        VCardImportRequest importRequest = new VCardImportRequest(this.folderID, new ByteArrayInputStream(vCard.getBytes()));
        VCardImportResponse importResponse = this.manager.getClient().execute(importRequest);
        JSONArray response = (JSONArray)importResponse.getData();
        Bug27151Test_RoundtripOfYomiFields.assertEquals((String)"Precondition: Should only find one contact in there", (int)1, (int)response.length());
        JSONObject jsonObject = response.getJSONObject(0);
        Contact actual = this.manager.getAction(this.folderID, jsonObject.getInt("id"));
        Bug27151Test_RoundtripOfYomiFields.assertEquals((String)"YomiFirstName1", (String)actual.getYomiFirstName());
        Bug27151Test_RoundtripOfYomiFields.assertEquals((String)"YomiLastName1", (String)actual.getYomiLastName());
    }
}

