/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.exception.OXException;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.java.Autoboxing;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONException;

public class UserValues {
    private final AJAXClient client;
    private String inboxFolder;
    private String sentFolder;
    private String trashFolder;
    private String draftsFolder;
    private String sendAddress;
    private Integer privateInfostoreFolder;
    private Integer infostoreTrashFolder;
    private Locale locale;
    private int privateAppointmentFolder = -1;
    private int privateContactFolder = -1;
    private int privateTaskFolder = -1;
    private TimeZone timeZone;
    private int userId = -1;
    private int contextId = -1;
    private String defaultAddress;

    public UserValues(AJAXClient client) {
        this.client = client;
    }

    public String getInboxFolder() throws OXException, IOException, JSONException {
        if (null == this.inboxFolder) {
            this.inboxFolder = this.client.execute(new GetRequest(Tree.InboxFolder)).getString();
        }
        return this.inboxFolder;
    }

    public String getSentFolder() throws OXException, IOException, JSONException {
        if (null == this.sentFolder) {
            this.sentFolder = this.client.execute(new GetRequest(Tree.SentFolder)).getString();
        }
        return this.sentFolder;
    }

    public String getTrashFolder() throws OXException, IOException, JSONException {
        if (null == this.trashFolder) {
            this.trashFolder = this.client.execute(new GetRequest(Tree.TrashFolder)).getString();
        }
        return this.trashFolder;
    }

    public String getDraftsFolder() throws OXException, IOException, JSONException {
        if (null == this.draftsFolder) {
            this.draftsFolder = this.client.execute(new GetRequest(Tree.DraftsFolder)).getString();
        }
        return this.draftsFolder;
    }

    public int getPrivateInfostoreFolder() throws OXException, IOException, JSONException {
        if (null == this.privateInfostoreFolder) {
            this.privateInfostoreFolder = Autoboxing.I((int)this.client.execute(new GetRequest(Tree.PrivateInfostoreFolder)).getInteger());
        }
        return this.privateInfostoreFolder;
    }

    public int getInfostoreTrashFolder() throws OXException, IOException, JSONException {
        if (null == this.infostoreTrashFolder) {
            this.infostoreTrashFolder = Autoboxing.I((int)this.client.execute(new GetRequest(Tree.InfostoreTrashFolder)).getInteger());
        }
        return this.infostoreTrashFolder;
    }

    public String getSendAddress() throws OXException, IOException, JSONException {
        if (null == this.sendAddress) {
            this.sendAddress = this.client.execute(new GetRequest(Tree.SendAddress)).getString();
        }
        return this.sendAddress;
    }

    public Locale getLocale() throws OXException, IOException, JSONException {
        if (null == this.locale) {
            String localeId = this.client.execute(new GetRequest(Tree.Language)).getString();
            this.locale = LocaleTools.getLocale((String)localeId);
        }
        return this.locale;
    }

    public int getPrivateAppointmentFolder() throws OXException, IOException, JSONException {
        if (-1 == this.privateAppointmentFolder) {
            this.privateAppointmentFolder = this.client.execute(new GetRequest(Tree.PrivateAppointmentFolder)).getInteger();
        }
        return this.privateAppointmentFolder;
    }

    public int getPrivateContactFolder() throws OXException, IOException, JSONException {
        if (-1 == this.privateContactFolder) {
            this.privateContactFolder = this.client.execute(new GetRequest(Tree.PrivateContactFolder)).getInteger();
        }
        return this.privateContactFolder;
    }

    public int getPrivateTaskFolder() throws OXException, IOException, JSONException {
        if (-1 == this.privateTaskFolder) {
            this.privateTaskFolder = this.client.execute(new GetRequest(Tree.PrivateTaskFolder)).getInteger();
        }
        return this.privateTaskFolder;
    }

    public Date getServerTime() throws OXException, IOException, JSONException {
        long serverTime = this.client.execute(new GetRequest(Tree.CurrentTime)).getLong();
        serverTime -= (long)this.getTimeZone().getOffset(serverTime);
        return new Date(serverTime);
    }

    public TimeZone getTimeZone() throws OXException, IOException, JSONException {
        if (null == this.timeZone) {
            String tzId = this.client.execute(new GetRequest(Tree.TimeZone)).getString();
            this.timeZone = TimeZone.getTimeZone(tzId);
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) throws OXException, IOException, JSONException {
        this.client.execute(new SetRequest(Tree.TimeZone, timeZone.getID()));
    }

    public int getUserId() throws OXException, IOException, JSONException {
        if (-1 == this.userId) {
            this.userId = this.client.execute(new GetRequest(Tree.Identifier)).getInteger();
        }
        return this.userId;
    }

    public int getContextId() throws OXException, IOException, JSONException {
        if (-1 == this.contextId) {
            this.contextId = this.client.execute(new GetRequest(Tree.ContextID)).getInteger();
        }
        return this.contextId;
    }

    public String getDefaultAddress() throws OXException, IOException, JSONException {
        if (null == this.defaultAddress) {
            this.defaultAddress = this.client.execute(new GetRequest(Tree.DefaultAddress)).getString();
        }
        return this.defaultAddress;
    }
}

