/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.folder.api2.AbstractFolderTest;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import java.util.Iterator;
import java.util.UUID;

public class Bug29853Test
extends AbstractFolderTest {
    private static final int THREAD_COUNT = 20;
    private FolderObject folder;

    public Bug29853Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.folder = this.createSingle(8, UUID.randomUUID().toString());
        this.folder.setParentFolderID(this.client.getValues().getPrivateInfostoreFolder());
        InsertRequest insertRequest = new InsertRequest((API)EnumAPI.OX_NEW, this.folder);
        InsertResponse insertResponse = this.client.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.folder);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.folder) {
            super.deleteFolders(true, this.folder);
        }
        super.tearDown();
    }

    public void testCreateWithSameName() throws Throwable {
        int i;
        String folderName = "a";
        FolderObject subfolder = this.createSingle(8, folderName);
        subfolder.setParentFolderID(this.folder.getObjectID());
        final InsertRequest insertRequest = new InsertRequest((API)EnumAPI.OX_NEW, subfolder);
        Runnable insertFolderRunnable = new Runnable(){

            @Override
            public void run() {
                Bug29853Test.this.client.executeSafe(insertRequest);
            }
        };
        Thread[] insertThreads = new Thread[20];
        for (i = 0; i < insertThreads.length; ++i) {
            insertThreads[i] = new Thread(insertFolderRunnable);
            insertThreads[i].start();
        }
        for (i = 0; i < insertThreads.length; ++i) {
            insertThreads[i].join();
        }
        ListRequest listRequest = new ListRequest((API)EnumAPI.OX_NEW, this.folder.getObjectID());
        ListResponse listResponse = this.client.execute(listRequest);
        Iterator<FolderObject> iterator = listResponse.getFolder();
        Bug29853Test.assertTrue((String)"No folder created", (boolean)iterator.hasNext());
        FolderObject createdFolder = iterator.next();
        Bug29853Test.assertNotNull((String)"No folder created", (Object)createdFolder);
        Bug29853Test.assertEquals((String)"Folder name wrong", (String)folderName, (String)createdFolder.getFolderName());
        Bug29853Test.assertFalse((String)("Folder was created " + listResponse.getArray().length + " times: " + listResponse.getResponse()), (boolean)iterator.hasNext());
    }

    public void testRenameToSameName() throws Throwable {
        int i;
        FolderObject[] subfolders = new FolderObject[20];
        for (int i2 = 0; i2 < 20; ++i2) {
            subfolders[i2] = this.createSingle(8, "f" + i2);
            subfolders[i2].setParentFolderID(this.folder.getObjectID());
            InsertRequest insertRequest = new InsertRequest((API)EnumAPI.OX_NEW, subfolders[i2]);
            InsertResponse insertResponse = this.client.execute(insertRequest);
            insertResponse.fillObject((DataObject)subfolders[i2]);
        }
        String folderName = "a";
        Thread[] updateThreads = new Thread[20];
        for (i = 0; i < 20; ++i) {
            subfolders[i].setFolderName(folderName);
            final UpdateRequest updateRequest = new UpdateRequest((API)EnumAPI.OX_NEW, subfolders[i]);
            Runnable updateRunnable = new Runnable(){

                @Override
                public void run() {
                    Bug29853Test.this.client.executeSafe(updateRequest);
                }
            };
            updateThreads[i] = new Thread(updateRunnable);
            updateThreads[i].start();
        }
        for (i = 0; i < 20; ++i) {
            updateThreads[i].join();
        }
        ListRequest listRequest = new ListRequest((API)EnumAPI.OX_NEW, this.folder.getObjectID());
        ListResponse listResponse = this.client.execute(listRequest);
        FolderObject renamedFolder = null;
        Iterator<FolderObject> iterator = listResponse.getFolder();
        while (iterator.hasNext()) {
            FolderObject folder = iterator.next();
            if (!folderName.equals(folder.getFolderName())) continue;
            if (null == renamedFolder) {
                renamedFolder = folder;
                continue;
            }
            Bug29853Test.fail((String)("Folder was renamed more than once: " + listResponse.getResponse()));
        }
        Bug29853Test.assertNotNull((String)"No folder renamed", renamedFolder);
    }
}

