/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AbstractFolderRequest;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.PathRequest;
import com.openexchange.ajax.folder.actions.PathResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import com.openexchange.test.PermissionTools;
import java.util.Date;

public class Bug16163Test
extends AbstractAJAXSession {
    private static final int[] ATTRIBUTES = new int[]{1, 300};
    private AJAXClient client;
    private FolderObject testFolder;
    private AJAXClient client2;
    private int appointmentFolder;

    public Bug16163Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.testFolder = new FolderObject();
        this.testFolder.setModule(2);
        this.appointmentFolder = this.client.getValues().getPrivateAppointmentFolder();
        this.testFolder.setParentFolderID(this.appointmentFolder);
        this.testFolder.setPermissions(PermissionTools.P(Autoboxing.I((int)this.client.getValues().getUserId()), "a/a", Autoboxing.I((int)this.client2.getValues().getUserId()), "v"));
        this.testFolder.setFolderName("testFolder4Bug16163-" + System.currentTimeMillis());
        InsertRequest iReq = new InsertRequest((API)EnumAPI.OUTLOOK, this.testFolder);
        InsertResponse iResp = this.client.execute(iReq);
        iResp.fillObject((DataObject)this.testFolder);
        this.testFolder.setLastModified(new Date());
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.testFolder));
        super.tearDown();
    }

    public void testPathRequestWorks() throws Throwable {
        AbstractFolderRequest request = new GetRequest((API)EnumAPI.OX_NEW, this.testFolder.getObjectID());
        this.client.execute(request);
        request = new GetRequest((API)EnumAPI.OUTLOOK, this.testFolder.getObjectID());
        this.client.execute(request);
        request = new PathRequest((API)EnumAPI.OUTLOOK, this.testFolder.getObjectID(), ATTRIBUTES, false);
        AbstractAJAXResponse response = (PathResponse)((Object)this.client2.execute(request));
        Object[][] data = ((AbstractColumnsResponse)response).getArray();
        Bug16163Test.assertFalse((String)("Path request should work for that folder, but failed with: " + response.getErrorMessage()), (boolean)response.hasError());
        int idPos = ((AbstractColumnsResponse)response).getColumnPos(1);
        Bug16163Test.assertTrue((String)"Response should contain folder identifier.", (idPos >= 0 ? 1 : 0) != 0);
        int namePos = ((AbstractColumnsResponse)response).getColumnPos(300);
        Bug16163Test.assertTrue((String)"Response should contain folder names.", (namePos >= 0 ? 1 : 0) != 0);
        Bug16163Test.assertTrue((String)("Path on Outlook like tree should have at least 4 parts, but has " + data.length), (data.length >= 4 ? 1 : 0) != 0);
        Bug16163Test.assertEquals((String)("Path should start with test folder but is folder " + data[0][namePos]), (Object)Integer.toString(this.testFolder.getObjectID()), (Object)data[0][idPos]);
        if (4 == data.length) {
            Bug16163Test.assertEquals((String)("Parent of created folder should be virtual shared user folder but is " + data[1][namePos]), (Object)("u:" + this.client.getValues().getUserId()), (Object)data[1][idPos]);
            Bug16163Test.assertEquals((String)("Parent of virtual shared user folder should be system shared root folder but is " + data[2][namePos]), (Object)Integer.toString(3), (Object)data[2][idPos]);
            Bug16163Test.assertEquals((String)("Root folder should be IPM_ROOT but is " + data[3][namePos]), (Object)FolderStorage.PRIVATE_ID, (Object)data[3][idPos]);
        } else {
            Bug16163Test.assertEquals((String)("Parent of created folder should be user1's Calendar folder but is " + data[1][namePos]), (Object)Integer.toString(this.appointmentFolder), (Object)data[1][idPos]);
            Bug16163Test.assertEquals((String)("Parent of created folder should be virtual shared user folder but is " + data[2][namePos]), (Object)("u:" + this.client.getValues().getUserId()), (Object)data[2][idPos]);
            Bug16163Test.assertEquals((String)("Parent of virtual shared user folder should be system shared root folder but is " + data[3][namePos]), (Object)Integer.toString(3), (Object)data[3][idPos]);
            Bug16163Test.assertEquals((String)("Root folder should be IPM_ROOT but is " + data[4][namePos]), (Object)FolderStorage.PRIVATE_ID, (Object)data[4][idPos]);
        }
        request = new GetRequest((API)EnumAPI.OUTLOOK, this.testFolder.getObjectID());
        response = this.client.execute(request);
        Bug16163Test.assertEquals((String)"Identifier of cached folder is broken.", (int)this.testFolder.getObjectID(), (int)((GetResponse)response).getFolder().getObjectID());
        request = new PathRequest((API)EnumAPI.OUTLOOK, this.testFolder.getObjectID(), ATTRIBUTES, false);
        response = (PathResponse)((Object)this.client.execute(request));
        data = ((AbstractColumnsResponse)response).getArray();
        Bug16163Test.assertFalse((String)"Path request should work for that folder.", (boolean)response.hasError());
        idPos = ((AbstractColumnsResponse)response).getColumnPos(1);
        Bug16163Test.assertTrue((String)"Response should contain folder identifier.", (idPos >= 0 ? 1 : 0) != 0);
        namePos = ((AbstractColumnsResponse)response).getColumnPos(300);
        Bug16163Test.assertTrue((String)"Response should contain folder names.", (namePos >= 0 ? 1 : 0) != 0);
        Bug16163Test.assertEquals((String)"Path on Outlook like tree should have 3 parts.", (int)3, (int)data.length);
        Bug16163Test.assertEquals((String)("Path should start with test folder but is folder " + data[0][namePos]), (Object)Integer.toString(this.testFolder.getObjectID()), (Object)data[0][idPos]);
        Bug16163Test.assertEquals((String)("Parent of created folder should be users private calendar folder but is " + data[1][namePos]), (Object)Integer.toString(this.appointmentFolder), (Object)data[1][idPos]);
        Bug16163Test.assertEquals((String)("Root folder should be IPM_ROOT but is " + data[2][namePos]), (Object)FolderStorage.PRIVATE_ID, (Object)data[2][idPos]);
    }
}

