/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.ClearRequest;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;

public class PermissionsCascadeTest
extends AbstractAJAXSession {
    private List<FolderObject> testFolders = new ArrayList<FolderObject>();
    private FolderObject rootFolder;
    private static final boolean CLEANUP = true;

    public PermissionsCascadeTest(String name) {
        super(name);
    }

    @Override
    public void tearDown() throws Exception {
        this.client.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.rootFolder.getObjectID(), this.rootFolder.getLastModified()));
        this.client.execute(new ClearRequest((API)EnumAPI.OUTLOOK, this.client.getValues().getInfostoreTrashFolder()));
        super.tearDown();
    }

    public void testCascadePermissionsInChildrenFolders() throws Exception {
        this.rootFolder = this.createSimpleTree("testCascadePermissionsInChildrenFolders", 5);
        this.assertCascadePermissions();
    }

    public void testCasccadePermissionsInSiblingFolders() throws Exception {
        this.rootFolder = this.createRandomTree("testCasccadePermissionsInSiblingFolders", 20);
        this.assertCascadePermissions();
    }

    private void assertCascadePermissions() throws Exception {
        GetResponse response = this.client.execute(new GetRequest((API)EnumAPI.OUTLOOK, this.rootFolder.getObjectID()));
        JSONObject data = (JSONObject)response.getData();
        long timestamp = data.getLong("last_modified");
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        this.rootFolder.addPermission(Create.ocl(client2.getValues().getUserId(), false, false, 2, 2, 0, 0));
        this.rootFolder.setLastModified(new Date(timestamp));
        this.client.execute(new UpdateRequest((API)EnumAPI.OUTLOOK, this.rootFolder).setCascadePermissions(true));
        for (int i = 2; i < this.testFolders.size(); ++i) {
            FolderObject fo = this.testFolders.get(i);
            response = this.client.execute(new GetRequest((API)EnumAPI.OUTLOOK, fo.getObjectID(), new int[]{300, 306}));
            List permissions = response.getFolder().getPermissions();
            boolean found = false;
            for (int p = 0; !found && p < permissions.size(); ++p) {
                found = ((OCLPermission)permissions.get(p)).getEntity() == client2.getValues().getUserId();
            }
            PermissionsCascadeTest.assertTrue((String)("Second user not found in permissions of folder '" + response.getFolder().getFolderName() + "'"), (boolean)found);
        }
    }

    public void testCascadePermissionsInTreeRollbackAndThenIgnore() throws Exception {
        this.rootFolder = this.createRandomTree("testCascadePermissionsInTreeRollback", 20);
        int rootNodeIdOfSubTree = -1;
        for (int f = 1; f < this.testFolders.size(); ++f) {
            GetResponse response = this.client.execute(new GetRequest((API)EnumAPI.OUTLOOK, this.testFolders.get(f).getObjectID(), new int[]{304}));
            if (!response.getFolder().hasSubfolders()) continue;
            rootNodeIdOfSubTree = response.getFolder().getObjectID();
            break;
        }
        if (rootNodeIdOfSubTree < 0) {
            rootNodeIdOfSubTree = this.testFolders.get(0).getObjectID();
        }
        ArrayList<FolderObject> tree = new ArrayList<FolderObject>();
        this.fetchAllSubfolders(rootNodeIdOfSubTree, tree);
        PermissionsCascadeTest.assertTrue((String)"No tree", (tree.size() > 0 ? 1 : 0) != 0);
        FolderObject leaf = (FolderObject)tree.get(tree.size() - 1);
        GetResponse response = this.client.execute(new GetRequest((API)EnumAPI.OUTLOOK, leaf.getObjectID()));
        JSONObject data = (JSONObject)response.getData();
        long timestamp = data.getLong("last_modified");
        leaf.setPermissions(response.getFolder().getPermissions());
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        leaf.addPermission(Create.ocl(client2.getValues().getUserId(), false, true, 128, 128, 128, 128));
        leaf.setLastModified(new Date(timestamp));
        this.client.execute(new UpdateRequest((API)EnumAPI.OUTLOOK, leaf));
        int lol = this.createFolder("Leaf", leaf.getObjectID(), client2).getObjectID();
        response = client2.execute(new GetRequest((API)EnumAPI.OUTLOOK, lol, new int[]{5, 306}));
        FolderObject leafOfLeaf = response.getFolder();
        timestamp = ((JSONObject)response.getData()).getLong("last_modified");
        leafOfLeaf.removePermissions();
        leafOfLeaf.addPermission(Create.ocl(client2.getValues().getUserId(), false, true, 128, 128, 128, 128));
        leafOfLeaf.setLastModified(new Date(timestamp));
        client2.execute(new UpdateRequest((API)EnumAPI.OUTLOOK, leafOfLeaf));
        response = this.client.execute(new GetRequest((API)EnumAPI.OUTLOOK, rootNodeIdOfSubTree, new int[]{5, 306}));
        FolderObject rootNode = response.getFolder();
        timestamp = ((JSONObject)response.getData()).getLong("last_modified");
        AJAXClient client3 = new AJAXClient(AJAXClient.User.User3);
        rootNode.addPermission(Create.ocl(client3.getValues().getUserId(), false, false, 2, 2, 0, 0));
        rootNode.setLastModified(new Date(timestamp));
        UpdateRequest setCascadePermissions = new UpdateRequest((API)EnumAPI.OUTLOOK, rootNode, false).setCascadePermissions(true);
        this.client.execute(setCascadePermissions);
        int owner = this.client.getValues().getUserId();
        int guest = client2.getValues().getUserId();
        int doe = client3.getValues().getUserId();
        this.assertPermissions(rootNode, new int[]{owner, doe}, new int[]{guest}, this.client);
        this.assertPermissions(leaf, new int[]{owner, guest}, new int[]{doe}, this.client);
        this.assertPermissions(leafOfLeaf, new int[]{guest}, new int[]{owner, doe}, client2);
        setCascadePermissions.setIgnoreWarnings(true);
        this.client.execute(setCascadePermissions);
        this.assertPermissions(rootNode, new int[]{owner}, new int[]{guest, doe}, this.client);
        this.assertPermissions(leaf, new int[]{owner, doe}, new int[]{guest}, this.client);
        this.assertPermissions(leafOfLeaf, new int[]{guest}, new int[]{owner, doe}, client2);
    }

    private void assertPermissions(FolderObject folderObject, int[] includedUsers, int[] excludedUsers, AJAXClient client) throws Exception {
        GetResponse getResponse = client.execute(new GetRequest((API)EnumAPI.OUTLOOK, folderObject.getObjectID()));
        List permissions = getResponse.getFolder().getPermissions();
        int pSize = permissions.size();
        PermissionsCascadeTest.assertEquals((String)("Unexpected number of permissions for folder '" + folderObject.getObjectID() + "': "), (int)includedUsers.length, (int)pSize);
        this.assertUserInPermissions(includedUsers, permissions, folderObject.getObjectID(), true);
        this.assertUserInPermissions(excludedUsers, permissions, folderObject.getObjectID(), false);
    }

    private void assertUserInPermissions(int[] userIds, List<OCLPermission> permissions, int folderId, boolean isContained) {
        boolean found = false;
        int[] arr$ = userIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer userId = arr$[i$];
            for (int i = 0; !found && i < permissions.size(); ++i) {
                found = permissions.get(i).getEntity() == userId.intValue();
            }
            PermissionsCascadeTest.assertEquals((String)("User " + (!isContained ? "not" : "") + " found in permissions for folder '" + folderId + "'"), (boolean)isContained, (boolean)found);
        }
    }

    private void fetchAllSubfolders(int folderId, List<FolderObject> tree) throws Exception {
        ListResponse listResponse = this.client.execute(new ListRequest((API)EnumAPI.OUTLOOK, Integer.toString(folderId), new int[]{1, 304, 306}, false));
        Iterator<FolderObject> iterator = listResponse.getFolder();
        while (iterator.hasNext()) {
            FolderObject fo = iterator.next();
            tree.add(fo);
            if (!fo.hasSubfolders()) continue;
            this.fetchAllSubfolders(fo.getObjectID(), tree);
        }
    }

    private FolderObject createFolder(String folderName, int parent) throws Exception {
        return this.createFolder(folderName, parent, this.client);
    }

    private FolderObject createFolder(String folderName, int parent, AJAXClient client) throws Exception {
        FolderObject folder = Create.createPrivateFolder(folderName, 8, client.getValues().getUserId(), new OCLPermission[0]);
        folder.setParentFolderID(parent);
        InsertResponse response = client.execute(new InsertRequest((API)EnumAPI.OUTLOOK, folder));
        response.fillObject((DataObject)folder);
        this.testFolders.add(folder);
        return folder;
    }

    private FolderObject createSimpleTree(String rootName, int levels) throws Exception {
        FolderObject rootFolder = this.createFolder(rootName, this.client.getValues().getPrivateInfostoreFolder());
        int parent = rootFolder.getObjectID();
        for (int i = 1; i <= levels; ++i) {
            parent = this.createFolder("Level " + i, parent).getObjectID();
        }
        return rootFolder;
    }

    private FolderObject createRandomTree(String rootName, int folderCount) throws Exception {
        FolderObject rootFolder = this.createFolder(rootName, this.client.getValues().getPrivateInfostoreFolder());
        int parentId = rootFolder.getObjectID();
        for (int i = 0; i < folderCount; ++i) {
            int r = (int)(Math.random() * (double)(this.testFolders.size() - 1));
            parentId = this.testFolders.get(r).getObjectID();
            this.createFolder(UUID.randomUUID().toString(), parentId);
        }
        return rootFolder;
    }
}

