/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GenJSONRequest;
import com.openexchange.ajax.folder.actions.GenJSONResponse;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONValue;

public class DefaultMediaFoldersTest
extends AbstractAJAXSession {
    private final int[] folders = new int[4];
    private final int[] types = new int[4];

    public DefaultMediaFoldersTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ListRequest listRequest = new ListRequest((API)EnumAPI.OX_NEW, String.valueOf(this.client.getValues().getPrivateInfostoreFolder()), new int[]{1, 300, 305, 306, 302, 308}, true);
        ListResponse listResponse = this.client.execute(listRequest);
        Iterator<FolderObject> it = listResponse.getFolder();
        while (it.hasNext()) {
            FolderObject folder = it.next();
            if (folder.getType() == 20) {
                DefaultMediaFoldersTest.assertEquals((String)"Wrong folder name.", (String)"Pictures", (String)folder.getFolderName());
                DefaultMediaFoldersTest.assertTrue((String)"Folder is not a default folder.", (boolean)folder.isDefaultFolder());
                this.folders[0] = folder.getObjectID();
                this.types[0] = 20;
            }
            if (folder.getType() == 21) {
                DefaultMediaFoldersTest.assertEquals((String)"Wrong folder name.", (String)"Documents", (String)folder.getFolderName());
                DefaultMediaFoldersTest.assertTrue((String)"Folder is not a default folder.", (boolean)folder.isDefaultFolder());
                this.folders[1] = folder.getObjectID();
                this.types[1] = 21;
            }
            if (folder.getType() == 22) {
                DefaultMediaFoldersTest.assertEquals((String)"Wrong folder name.", (String)"Music", (String)folder.getFolderName());
                DefaultMediaFoldersTest.assertTrue((String)"Folder is not a default folder.", (boolean)folder.isDefaultFolder());
                this.folders[2] = folder.getObjectID();
                this.types[2] = 22;
            }
            if (folder.getType() != 23) continue;
            DefaultMediaFoldersTest.assertEquals((String)"Wrong folder name.", (String)"Videos", (String)folder.getFolderName());
            DefaultMediaFoldersTest.assertTrue((String)"Folder is not a default folder.", (boolean)folder.isDefaultFolder());
            this.folders[3] = folder.getObjectID();
            this.types[3] = 23;
        }
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDelete() throws Exception {
        for (int folderId : this.folders) {
            DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OX_NEW, folderId, new Date());
            deleteRequest.setHardDelete(true);
            CommonDeleteResponse deleteResponse = this.client.execute(deleteRequest);
            JSONArray json = (JSONArray)deleteResponse.getData();
            DefaultMediaFoldersTest.assertEquals((String)"Wrong array size in response.", (int)1, (int)json.length());
            DefaultMediaFoldersTest.assertEquals((String)"Wrong folder Id in response.", (int)folderId, (int)json.getInt(0));
            GetRequest getRequest = new GetRequest((API)EnumAPI.OX_NEW, folderId);
            GetResponse getResponse = this.client.execute(getRequest);
            DefaultMediaFoldersTest.assertFalse((String)("Folder " + folderId + " was deleted."), (boolean)getResponse.hasError());
        }
    }

    public void testRename() throws Exception {
        for (int folderId : this.folders) {
            GetRequest getRequest = new GetRequest((API)EnumAPI.OX_NEW, folderId);
            GetResponse getResponse = this.client.execute(getRequest);
            if (getResponse.hasError()) {
                DefaultMediaFoldersTest.fail((String)getResponse.getErrorMessage());
            }
            FolderObject folder = getResponse.getFolder();
            folder.setFolderName("renamed");
            folder.setLastModified(new Date());
            UpdateRequest updateRequest = new UpdateRequest((API)EnumAPI.OX_NEW, folder, false);
            InsertResponse updateResponse = this.client.execute(updateRequest);
            DefaultMediaFoldersTest.assertTrue((String)("Media folder " + folderId + " renamed."), (boolean)updateResponse.hasError());
            OXException e = updateResponse.getException();
            DefaultMediaFoldersTest.assertEquals((int)OXFolderExceptionCode.NO_DEFAULT_FOLDER_RENAME.getNumber(), (int)e.getCode());
        }
    }

    public void testMove() throws Exception {
        int random = new Random(System.currentTimeMillis()).nextInt(4);
        GetRequest getRequest = new GetRequest((API)EnumAPI.OX_NEW, this.folders[random]);
        GetResponse getResponse = this.client.execute(getRequest);
        if (getResponse.hasError()) {
            DefaultMediaFoldersTest.fail((String)getResponse.getErrorMessage());
        }
        FolderObject folder = getResponse.getFolder();
        GenJSONRequest updateRequest = new GenJSONRequest((API)EnumAPI.OX_NEW, false);
        updateRequest.setJSONValue((JSONValue)new JSONObject("{\"folder_id\":\"" + this.folders[(random + 1) % 4] + "\"}"));
        updateRequest.setParameter("action", "update");
        updateRequest.setParameter("id", String.valueOf(folder.getObjectID()));
        GenJSONResponse updateResponse = this.client.execute(updateRequest);
        DefaultMediaFoldersTest.assertTrue((String)"Media folder moved.", (boolean)updateResponse.hasError());
        OXException e = updateResponse.getException();
        DefaultMediaFoldersTest.assertEquals((int)OXFolderExceptionCode.NO_DEFAULT_FOLDER_MOVE.getNumber(), (int)e.getCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testSubfoldersInheritType() throws Exception {
        int random = new Random(System.currentTimeMillis()).nextInt(4);
        FolderObject folder = new FolderObject();
        folder.setFolderName("subfolder");
        folder.setParentFolderID(this.folders[random]);
        folder.setModule(8);
        OCLPermission perm = new OCLPermission(this.client.getValues().getUserId(), this.folders[random]);
        perm.setFolderAdmin(true);
        folder.setPermissions(Collections.singletonList(perm));
        int subfolderId = -1;
        try {
            InsertRequest insertRequest = new InsertRequest((API)EnumAPI.OX_NEW, folder);
            InsertResponse insertResponse = this.client.execute(insertRequest);
            insertResponse.fillObject((DataObject)folder);
            folder.setLastModified(new Date());
            subfolderId = folder.getObjectID();
            GetRequest getRequest = new GetRequest((API)EnumAPI.OX_NEW, subfolderId, new int[]{302});
            GetResponse getResponse = this.client.execute(getRequest);
            folder = getResponse.getFolder();
            DefaultMediaFoldersTest.assertEquals((String)"Folder type is not correct.", (int)this.types[random], (int)folder.getType());
            if (subfolderId <= 0) return;
        }
        catch (Throwable throwable) {
            if (subfolderId <= 0) throw throwable;
            folder.setLastModified(new Date());
            DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OX_NEW, false, folder);
            deleteRequest.setHardDelete(true);
            this.client.execute(deleteRequest);
            throw throwable;
        }
        folder.setLastModified(new Date());
        DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OX_NEW, false, folder);
        deleteRequest.setHardDelete(true);
        this.client.execute(deleteRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testSubfolderChangeTypeOnMove() throws Exception {
        int random = new Random(System.currentTimeMillis()).nextInt(4);
        FolderObject folder = new FolderObject();
        folder.setFolderName("subfolder");
        folder.setParentFolderID(this.folders[random]);
        folder.setModule(8);
        OCLPermission perm = new OCLPermission(this.client.getValues().getUserId(), this.folders[random]);
        perm.setFolderAdmin(true);
        folder.setPermissions(Collections.singletonList(perm));
        int subfolderId = -1;
        try {
            InsertRequest insertRequest = new InsertRequest((API)EnumAPI.OX_NEW, folder);
            InsertResponse insertResponse = this.client.execute(insertRequest);
            insertResponse.fillObject((DataObject)folder);
            subfolderId = folder.getObjectID();
            GetRequest getRequest = new GetRequest((API)EnumAPI.OX_NEW, subfolderId);
            GetResponse getResponse = this.client.execute(getRequest);
            folder = getResponse.getFolder();
            folder.setLastModified(new Date());
            GenJSONRequest updateRequest = new GenJSONRequest((API)EnumAPI.OX_NEW, false);
            updateRequest.setJSONValue((JSONValue)new JSONObject("{\"folder_id\":\"" + this.folders[(random + 1) % 4] + "\"}"));
            updateRequest.setParameter("action", "update");
            updateRequest.setParameter("id", String.valueOf(subfolderId));
            GenJSONResponse updateResponse = this.client.execute(updateRequest);
            DefaultMediaFoldersTest.assertFalse((String)"Move subfolder failed.", (boolean)updateResponse.hasError());
            getRequest = new GetRequest((API)EnumAPI.OX_NEW, subfolderId);
            getResponse = this.client.execute(getRequest);
            folder = getResponse.getFolder();
            folder.setLastModified(new Date());
            DefaultMediaFoldersTest.assertEquals((String)"Folder type not changed when moved.", (int)this.types[(random + 1) % 4], (int)folder.getType());
            if (subfolderId <= 0) return;
        }
        catch (Throwable throwable) {
            if (subfolderId <= 0) throw throwable;
            DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OX_NEW, false, folder);
            deleteRequest.setHardDelete(true);
            this.client.execute(deleteRequest);
            throw throwable;
        }
        DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OX_NEW, false, folder);
        deleteRequest.setHardDelete(true);
        this.client.execute(deleteRequest);
    }
}

