/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.mail;

import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.find.actions.QueryRequest;
import com.openexchange.ajax.find.actions.QueryResponse;
import com.openexchange.ajax.find.mail.AbstractMailFindTest;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.find.Document;
import com.openexchange.find.Module;
import com.openexchange.find.SearchResult;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Charsets;
import com.openexchange.java.util.TimeZones;
import com.openexchange.mail.utils.DateUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class Bug39105Test
extends AbstractMailFindTest {
    private FolderObject testFolder;

    public Bug39105Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String inboxFolder = this.client.getValues().getInboxFolder();
        String folderName = "Bug39105Test_" + System.currentTimeMillis();
        this.testFolder = new FolderObject();
        this.testFolder.setModule(7);
        this.testFolder.setFullName(inboxFolder + "/" + folderName);
        this.testFolder.setFolderName(folderName);
        this.testFolder = this.folderManager.insertFolderOnServer(this.testFolder);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReturnCustomHeader() throws Exception {
        String mail = "From: #FROM#\nTo: #TO#\nCC: #TO#\nBCC: #TO#\nReceived: from ox.open-xchange.com;#DATE#\nDate: #DATE#\nSubject: #SUBJECT#\nDisposition-Notification-To: #FROM#\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\nX-OX-Test-Header: #HEADER_VALUE#\n\nContent\n#BODY#\n";
        String header = Bug39105Test.randomUID();
        String subject = Bug39105Test.randomUID();
        mail = mail.replaceAll("#FROM#", this.defaultAddress).replaceAll("#TO#", this.defaultAddress).replaceAll("#DATE#", DateUtils.toStringRFC822((Date)new Date(), (TimeZone)TimeZones.UTC)).replaceAll("#SUBJECT#", subject).replaceAll("#BODY#", Bug39105Test.randomUID()).replaceAll("#HEADER_VALUE#", header);
        ByteArrayInputStream mailStream = new ByteArrayInputStream(mail.getBytes(Charsets.UTF_8));
        ImportMailRequest request = new ImportMailRequest(this.testFolder.getFullName(), 0, true, true, (InputStream[])new ByteArrayInputStream[]{mailStream});
        ImportMailResponse response = this.client.execute(request);
        String[][] mailIds = response.getIds();
        String[] columns = new String[]{"601", "600", "X-OX-Test-Header"};
        List<ActiveFacet> facets = this.prepareFacets(this.testFolder.getFullName());
        facets.add(Bug39105Test.createQuery(subject));
        QueryRequest queryRequest = new QueryRequest(0, Integer.MAX_VALUE, facets, Module.MAIL.getIdentifier(), columns);
        QueryResponse queryResponse = this.client.execute(queryRequest);
        SearchResult result = queryResponse.getSearchResult();
        ArrayList<PropDocument> propDocuments = new ArrayList<PropDocument>();
        List documents = result.getDocuments();
        for (Document document : documents) {
            propDocuments.add((PropDocument)document);
        }
        PropDocument foundMail = Bug39105Test.findByProperty(propDocuments, "id", mailIds[0][1]);
        Bug39105Test.assertNotNull((String)"Mail not found", (Object)foundMail);
        Bug39105Test.assertEquals((String)"Header not set", (Object)header, (Object)foundMail.getProps().get("X-OX-Test-Header"));
    }
}

