/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.contacts;

import com.openexchange.ajax.find.AbstractFindTest;
import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.find.Module;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.ContactTestManager;
import com.openexchange.tools.arrays.Arrays;
import java.util.Date;
import java.util.List;

public abstract class ContactsFindTest
extends AbstractFindTest {
    static final int[] PHONE_COLUMNS = new int[]{568, 542, 543, 545, 546, 547, 548, 549, 567, 559, 553, 560, 561, 562, 563, 564};
    static final int[] NAME_COLUMNS = new int[]{500, 502, 503, 501, 505, 616, 617, 504};
    static final int[] EMAIL_COLUMNS = new int[]{555, 556, 557};
    static final int[] ADDRESS_COLUMNS = new int[]{523, 506, 538, 525, 507, 540, 526, 508, 539, 527, 509, 598, 528, 510, 541};
    static final int[] ADDRESSBOOK_COLUMNS = Arrays.addUniquely((int[])NAME_COLUMNS, (int[])Arrays.addUniquely((int[])ADDRESS_COLUMNS, (int[])Arrays.addUniquely((int[])PHONE_COLUMNS, (int[])EMAIL_COLUMNS)));
    protected ContactTestManager manager;
    protected int folderID;

    public ContactsFindTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = new ContactTestManager(this.getClient());
        UserValues values = this.getClient().getValues();
        FolderObject folder = this.folderManager.generatePublicFolder("ManagedContactTest_" + new Date().getTime(), com.openexchange.groupware.modules.Module.CONTACTS.getFolderConstant(), values.getPrivateContactFolder(), values.getUserId());
        folder = this.folderManager.insertFolderOnServer(folder);
        this.folderID = folder.getObjectID();
    }

    @Override
    protected void tearDown() throws Exception {
        this.manager.cleanUp();
        super.tearDown();
    }

    protected List<PropDocument> query(List<ActiveFacet> facets) throws Exception {
        return this.query(Module.CONTACTS, facets);
    }

    protected Contact randomContact() {
        Contact contact = new Contact();
        contact.setParentFolderID(this.folderID);
        contact.setSurName(ContactsFindTest.randomUID());
        contact.setGivenName(ContactsFindTest.randomUID());
        contact.setDisplayName(contact.getGivenName() + " " + contact.getSurName());
        contact.setEmail1(ContactsFindTest.randomUID() + "@example.com");
        contact.setUid(ContactsFindTest.randomUID());
        return contact;
    }

    protected Contact randomContact(int parentFolder) {
        Contact contact = new Contact();
        contact.setParentFolderID(parentFolder);
        contact.setSurName(ContactsFindTest.randomUID());
        contact.setGivenName(ContactsFindTest.randomUID());
        contact.setDisplayName(contact.getGivenName() + " " + contact.getSurName());
        contact.setEmail1(ContactsFindTest.randomUID() + "@example.com");
        contact.setUid(ContactsFindTest.randomUID());
        return contact;
    }
}

