/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.drive.test;

import com.openexchange.ajax.drive.action.DeleteLinkRequest;
import com.openexchange.ajax.drive.action.GetLinkRequest;
import com.openexchange.ajax.drive.action.GetLinkResponse;
import com.openexchange.ajax.drive.action.UpdateLinkRequest;
import com.openexchange.ajax.drive.test.AbstractDriveShareTest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.drive.DriveShareTarget;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.java.util.UUIDs;
import com.openexchange.test.TestInit;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class UpdateLinkTest
extends AbstractDriveShareTest {
    private InfostoreTestManager itm;
    private FolderObject rootFolder;
    private FolderObject folder;
    private DefaultFile file;
    private FolderObject folder2;

    public UpdateLinkTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.itm = new InfostoreTestManager(this.client);
        UserValues values = this.client.getValues();
        this.rootFolder = this.insertPrivateFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), values.getPrivateInfostoreFolder());
        this.folder = this.insertPrivateFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), this.rootFolder.getObjectID());
        this.folder2 = this.insertPrivateFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), this.rootFolder.getObjectID());
        long now = System.currentTimeMillis();
        this.file = new DefaultFile();
        this.file.setFolderId(String.valueOf(this.folder2.getObjectID()));
        this.file.setTitle("GetLinkTest_" + now);
        this.file.setFileName(this.file.getTitle());
        this.file.setDescription(this.file.getTitle());
        this.file.setFileMD5Sum(this.getChecksum(new File(TestInit.getTestProperty("ajaxPropertiesFile"))));
        this.itm.newAction((com.openexchange.file.storage.File)this.file, new File(TestInit.getTestProperty("ajaxPropertiesFile")));
    }

    public void testUpdateFileLink() throws Exception {
        DriveShareTarget target = new DriveShareTarget();
        target.setDrivePath("/" + this.folder2.getFolderName());
        target.setName(this.file.getFileName());
        target.setChecksum(this.file.getFileMD5Sum());
        GetLinkRequest getLinkRequest = new GetLinkRequest(this.rootFolder.getObjectID(), target);
        GetLinkResponse getLinkResponse = this.client.execute(getLinkRequest);
        String url = getLinkResponse.getUrl();
        GuestClient guestClient = this.resolveShare(url, null, null);
        OCLGuestPermission expectedPermission = UpdateLinkTest.createAnonymousGuestPermission();
        expectedPermission.setEntity(guestClient.getValues().getUserId());
        guestClient.checkShareAccessible(expectedPermission);
        Map<String, Object> newMeta = Collections.singletonMap("test", Boolean.TRUE);
        String newPassword = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        Date newExpiry = new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L));
        UpdateLinkRequest updateLinkRequest = new UpdateLinkRequest(this.rootFolder.getObjectID(), target, newExpiry.getTime(), newPassword, newMeta, true);
        this.client.execute(updateLinkRequest);
        GuestClient newClient = this.resolveShare(url, null, newPassword);
        newClient.checkFileAccessible(this.file.getId(), expectedPermission);
        int guestID = guestClient.getValues().getUserId();
        ExtendedPermissionEntity guestEntity = this.discoverGuestEntity(this.file.getFolderId(), this.file.getId(), guestID);
        UpdateLinkTest.assertNotNull((Object)guestEntity);
        UpdateLinkTest.assertEquals((Object)newExpiry, (Object)guestEntity.getExpiry());
        this.client.execute(new DeleteLinkRequest(this.rootFolder.getObjectID(), target));
        guestEntity = this.discoverGuestEntity(this.file.getFolderId(), this.file.getId(), guestID);
        UpdateLinkTest.assertNull((String)"Share was not deleted", (Object)guestEntity);
        List objectPermissions = this.client.execute(new GetInfostoreRequest(this.file.getId())).getDocumentMetadata().getObjectPermissions();
        UpdateLinkTest.assertTrue((String)"Permission was not deleted", (boolean)objectPermissions.isEmpty());
    }

    public void testUpdateFolderLink() throws Exception {
        DriveShareTarget target = new DriveShareTarget();
        target.setDrivePath("/" + this.folder.getFolderName());
        target.setChecksum("d41d8cd98f00b204e9800998ecf8427e");
        GetLinkRequest getLinkRequest = new GetLinkRequest(this.rootFolder.getObjectID(), target);
        GetLinkResponse getLinkResponse = this.client.execute(getLinkRequest);
        String url = getLinkResponse.getUrl();
        GuestClient guestClient = this.resolveShare(url, null, null);
        OCLGuestPermission expectedPermission = UpdateLinkTest.createAnonymousGuestPermission();
        expectedPermission.setEntity(guestClient.getValues().getUserId());
        guestClient.checkShareAccessible(expectedPermission);
        Map<String, Object> newMeta = Collections.singletonMap("test", Boolean.TRUE);
        String newPassword = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        Date newExpiry = new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L));
        UpdateLinkRequest updateLinkRequest = new UpdateLinkRequest(this.rootFolder.getObjectID(), target, newExpiry.getTime(), newPassword, newMeta, true);
        this.client.execute(updateLinkRequest);
        GuestClient newClient = this.resolveShare(url, null, newPassword);
        newClient.checkFolderAccessible(Integer.toString(this.folder.getObjectID()), expectedPermission);
        String folder = guestClient.getFolder();
        String item = guestClient.getItem();
        int guestID = guestClient.getValues().getUserId();
        ExtendedPermissionEntity guestEntity = target.isFolder() ? this.discoverGuestEntity(EnumAPI.OX_NEW, 8, Integer.parseInt(folder), guestID) : this.discoverGuestEntity(folder, item, guestID);
        UpdateLinkTest.assertNotNull((Object)guestEntity);
        UpdateLinkTest.assertEquals((Object)newExpiry, (Object)guestEntity.getExpiry());
        this.client.execute(new DeleteLinkRequest(this.rootFolder.getObjectID(), target));
        guestEntity = target.isFolder() ? this.discoverGuestEntity(EnumAPI.OX_NEW, 8, Integer.parseInt(folder), guestID) : this.discoverGuestEntity(folder, item, guestID);
        UpdateLinkTest.assertNull((String)"Share was not deleted", (Object)guestEntity);
        List objectPermissions = this.client.execute(new GetInfostoreRequest(this.file.getId())).getDocumentMetadata().getObjectPermissions();
        UpdateLinkTest.assertTrue((String)"Permission was not deleted", (boolean)objectPermissions.isEmpty());
    }

    @Override
    public void tearDown() throws Exception {
        this.itm.cleanUp();
        super.tearDown();
    }
}

