/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class Bug42018Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private Appointment appointment;
    boolean works = false;

    public Bug42018Test(String name) {
        super(name);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.client);
        this.ctm.setFailOnError(true);
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 42018 Test");
        if (this.works) {
            this.appointment.setStartDate(TimeTools.D("03.08.2015 08:00"));
            this.appointment.setEndDate(TimeTools.D("03.08.2015 09:00"));
        } else {
            this.appointment.setStartDate(TimeTools.D("07.09.2015 08:00"));
            this.appointment.setEndDate(TimeTools.D("07.09.2015 09:00"));
        }
        this.appointment.setFullTime(true);
        this.appointment.setRecurrenceType(2);
        this.appointment.setDays(2);
        this.appointment.setInterval(1);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
    }

    @Test
    public void testBug42018() throws Exception {
        this.ctm.insert(this.appointment);
        this.ctm.createDeleteException(this.appointment, 3);
        Appointment loadedAppointment = this.ctm.get(this.appointment);
        Bug42018Test.assertNotNull((String)"Expect delete exception.", (Object)loadedAppointment.getDeleteException());
        Bug42018Test.assertEquals((String)"Expect exactly one delete exception", (int)1, (int)loadedAppointment.getDeleteException().length);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

