/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.resource.ResourceTools;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.Date;

public class Bug39571Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private Appointment series;
    private int nextYear;
    private Appointment single;

    public Bug39571Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.nextYear = Calendar.getInstance().get(1) + 1;
        UserParticipant up1 = new UserParticipant(this.client.getValues().getUserId());
        ResourceParticipant resourceParticipant = new ResourceParticipant(ResourceTools.getSomeResource(this.client));
        this.ctm = new CalendarTestManager(this.client);
        this.series = new Appointment();
        this.series.setTitle("Bug 39571 Series");
        this.series.setStartDate(TimeTools.D("01.08." + this.nextYear + " 08:00"));
        this.series.setEndDate(TimeTools.D("01.08." + this.nextYear + " 08:30"));
        this.series.setRecurrenceType(1);
        this.series.setInterval(1);
        this.series.setOccurrence(3);
        this.series.setParticipants(new Participant[]{up1, resourceParticipant});
        this.series.setIgnoreConflicts(true);
        this.series.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.ctm.insert(this.series);
        this.single = new Appointment();
        this.single.setTitle("Bug 39571 Single");
        this.single.setStartDate(TimeTools.D("02.08." + this.nextYear + " 09:00"));
        this.single.setEndDate(TimeTools.D("02.08." + this.nextYear + " 09:30"));
        this.single.setParticipants(new Participant[]{up1, resourceParticipant});
        this.single.setIgnoreConflicts(true);
        this.single.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.ctm.insert(this.single);
    }

    public void testBug39571() throws Exception {
        Appointment exception = this.ctm.createIdentifyingCopy(this.series);
        exception.setStartDate(TimeTools.D("02.08." + this.nextYear + " 06:00"));
        exception.setEndDate(TimeTools.D("02.08." + this.nextYear + " 06:30"));
        exception.setRecurrencePosition(2);
        this.ctm.update(exception);
        this.series.setStartDate(TimeTools.D("01.08." + this.nextYear + " 09:00"));
        this.series.setEndDate(TimeTools.D("01.08." + this.nextYear + " 09:30"));
        this.series.setLastModified(new Date(Long.MAX_VALUE));
        this.ctm.update(this.series);
        Bug39571Test.assertTrue((String)"Excpected conflicting ressource.", (boolean)this.ctm.getLastResponse().hasConflicts());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

