/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.Date;

public class Bug35610Test
extends AbstractAJAXSession {
    private AJAXClient client2;
    private CalendarTestManager ctm1;
    private CalendarTestManager ctm2;
    private Appointment app;
    private int nextYear;

    public Bug35610Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.ctm1 = new CalendarTestManager(this.getClient());
        this.ctm2 = new CalendarTestManager(this.client2);
        this.nextYear = Calendar.getInstance().get(1) + 1;
        this.app = new Appointment();
        this.app.setTitle("Bug 35610 Test");
        this.app.setStartDate(TimeTools.D("26.11." + this.nextYear + " 08:00"));
        this.app.setEndDate(TimeTools.D("26.11." + this.nextYear + " 09:00"));
        this.app.setRecurrenceType(1);
        this.app.setInterval(1);
        this.app.setOccurrence(5);
        UserParticipant user1 = new UserParticipant(this.client.getValues().getUserId());
        UserParticipant user2 = new UserParticipant(this.client2.getValues().getUserId());
        this.app.setParticipants(new Participant[]{user1, user2});
        this.app.setUsers(new UserParticipant[]{user1, user2});
        this.app.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.app.setIgnoreConflicts(true);
    }

    public void testTimeChange() throws Exception {
        this.ctm1.insert(this.app);
        this.ctm2.confirm(this.app, 1, "yay");
        Appointment exception = this.ctm1.createIdentifyingCopy(this.app);
        exception.setRecurrenceType(0);
        exception.removeInterval();
        exception.removeOccurrence();
        exception.setRecurrencePosition(3);
        exception.setStartDate(TimeTools.D("28.11." + this.nextYear + " 12:00"));
        exception.setEndDate(TimeTools.D("28.11." + this.nextYear + " 13:00"));
        exception.setLastModified(new Date(Long.MAX_VALUE));
        exception.setIgnoreConflicts(true);
        this.ctm1.update(exception);
        Appointment loadedException = this.ctm1.get(exception);
        for (UserParticipant up : loadedException.getUsers()) {
            if (up.getIdentifier() == this.client.getValues().getUserId()) {
                Bug35610Test.assertEquals((String)"Wrong confirmation status.", (int)1, (int)up.getConfirm());
            }
            if (up.getIdentifier() != this.client2.getValues().getUserId()) continue;
            Bug35610Test.assertEquals((String)"Wrong confirmation status.", (int)0, (int)up.getConfirm());
        }
    }

    public void testNoTimeChange() throws Exception {
        this.ctm1.insert(this.app);
        this.ctm2.confirm(this.app, 1, "yay");
        Appointment exception = this.ctm1.createIdentifyingCopy(this.app);
        exception.setRecurrenceType(0);
        exception.removeInterval();
        exception.removeOccurrence();
        exception.setRecurrencePosition(3);
        exception.setStartDate(TimeTools.D("28.11." + this.nextYear + " 08:00"));
        exception.setEndDate(TimeTools.D("28.11." + this.nextYear + " 09:00"));
        exception.setLastModified(new Date(Long.MAX_VALUE));
        exception.setIgnoreConflicts(true);
        this.ctm1.update(exception);
        Appointment loadedException = this.ctm1.get(exception);
        for (UserParticipant up : loadedException.getUsers()) {
            if (up.getIdentifier() == this.client.getValues().getUserId()) {
                Bug35610Test.assertEquals((String)"Wrong confirmation status.", (int)1, (int)up.getConfirm());
            }
            if (up.getIdentifier() != this.client2.getValues().getUserId()) continue;
            Bug35610Test.assertEquals((String)"Wrong confirmation status.", (int)1, (int)up.getConfirm());
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm1.cleanUp();
        this.ctm2.cleanUp();
        super.tearDown();
    }
}

