/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import org.junit.Test;

public class Bug31779Test
extends AbstractAJAXSession {
    private AJAXClient client1;
    private AJAXClient client2;
    private CalendarTestManager ctm1;
    private int nextYear;
    private Appointment appointment;
    private CalendarTestManager ctm2;

    public Bug31779Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client1 = this.client;
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.ctm1 = new CalendarTestManager(this.client1);
        this.ctm2 = new CalendarTestManager(this.client2);
        this.nextYear = Calendar.getInstance().get(1) + 1;
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 31779 appointment.");
        this.appointment.setStartDate(TimeTools.D("01.04." + this.nextYear + " 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.04." + this.nextYear + " 09:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        UserParticipant user1 = new UserParticipant(this.client1.getValues().getUserId());
        UserParticipant user2 = new UserParticipant(this.client2.getValues().getUserId());
        this.appointment.setParticipants(new Participant[]{user1, user2});
        this.appointment.setUsers(new UserParticipant[]{user1, user2});
        this.ctm1.insert(this.appointment);
    }

    @Test
    public void testBug31779() throws Exception {
        Appointment exception = this.ctm2.createIdentifyingCopy(this.appointment);
        exception.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        exception.setNote("Hello World");
        exception.setRecurrencePosition(2);
        this.ctm2.update(exception);
        exception.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.ctm1.delete(this.ctm1.createIdentifyingCopy(exception));
        exception.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        Appointment loadedException = this.ctm2.get(exception);
        Bug31779Test.assertNull((String)"No object expected.", (Object)loadedException);
        Bug31779Test.assertTrue((String)"Error expected.", (boolean)this.ctm2.getLastResponse().hasError());
        Bug31779Test.assertTrue((String)"No object expected.", (boolean)this.ctm2.getLastResponse().getErrorMessage().contains("Object not found"));
    }

    @Test
    public void testDeleteByparticipant() throws Exception {
        Appointment exception = this.ctm2.createIdentifyingCopy(this.appointment);
        exception.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        exception.setNote("Hello World");
        exception.setRecurrencePosition(2);
        this.ctm2.update(exception);
        this.ctm2.delete(this.ctm2.createIdentifyingCopy(exception));
        exception.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        Appointment loadedException = this.ctm1.get(exception);
        Bug31779Test.assertNotNull((String)"Object expected.", (Object)loadedException);
        Bug31779Test.assertEquals((String)"Wrong creator.", (int)this.client1.getValues().getUserId(), (int)loadedException.getCreatedBy());
        Bug31779Test.assertEquals((String)"Wrong changer.", (int)this.client2.getValues().getUserId(), (int)loadedException.getModifiedBy());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm1.cleanUp();
        this.ctm2.cleanUp();
        super.tearDown();
    }
}

