/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.ConflictObject;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class Bug30414Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private Appointment series;
    private Appointment single;
    private int nextYear;

    public Bug30414Test(String name) {
        super(name);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.client);
        this.nextYear = Calendar.getInstance().get(1) + 1;
        this.single = new Appointment();
        this.single.setTitle("Bug 30414 single appointment.");
        this.single.setStartDate(TimeTools.D("03.02." + this.nextYear + " 08:00"));
        this.single.setEndDate(TimeTools.D("03.02." + this.nextYear + " 09:00"));
        this.single.setIgnoreConflicts(true);
        this.single.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.ctm.insert(this.single);
        this.series = new Appointment();
        this.series.setTitle("Bug 30414 series appointment.");
        this.series.setStartDate(TimeTools.D("01.02." + this.nextYear + " 08:00"));
        this.series.setEndDate(TimeTools.D("01.02." + this.nextYear + " 09:00"));
        this.series.setRecurrenceType(1);
        this.series.setInterval(2);
        this.series.setOccurrence(3);
        this.series.setIgnoreConflicts(true);
        this.series.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.ctm.insert(this.series);
    }

    @Test
    public void testBug30414() throws Exception {
        Appointment exception2 = this.ctm.createIdentifyingCopy(this.series);
        exception2.setStartDate(TimeTools.D("02.02." + this.nextYear + " 08:00"));
        exception2.setEndDate(TimeTools.D("02.02." + this.nextYear + " 09:00"));
        exception2.setRecurrencePosition(2);
        Appointment exception = this.series.clone();
        exception.removeRecurrenceType();
        exception.removeInterval();
        exception.removeOccurrence();
        exception.setIgnoreConflicts(false);
        exception.setStartDate(TimeTools.D("02.02." + this.nextYear + " 08:00"));
        exception.setEndDate(TimeTools.D("02.02." + this.nextYear + " 09:00"));
        exception.setRecurrenceType(0);
        exception.setRecurrencePosition(2);
        this.ctm.update(exception);
        List<ConflictObject> conflicts = ((UpdateResponse)this.ctm.getLastResponse()).getConflicts();
        boolean foundBadConflict = false;
        if (conflicts != null) {
            for (ConflictObject co : conflicts) {
                if (co.getId() != this.single.getObjectID()) continue;
                foundBadConflict = true;
                break;
            }
        }
        Bug30414Test.assertFalse((String)"Found conflict", (boolean)foundBadConflict);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

