/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.FolderTestManager;

public class Bug26842Test
extends AbstractAJAXSession {
    private FolderObject folder;
    private FolderTestManager ftm;
    private CalendarTestManager ctm;

    public Bug26842Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ftm = new FolderTestManager(this.client);
        this.ctm = new CalendarTestManager(this.client);
        this.ctm.setFailOnError(true);
        this.folder = this.ftm.generatePublicFolder("26842-" + System.currentTimeMillis(), 2, 2, new int[0]);
        OCLPermission permission = new OCLPermission();
        permission.setEntity(this.client.getValues().getUserId());
        permission.setGroupPermission(false);
        permission.setFolderAdmin(true);
        permission.setAllPermission(4, 4, 4, 4);
        this.folder.addPermission(permission);
        this.ftm.insertFolderOnServer(this.folder);
    }

    public void testBug() throws Exception {
        Appointment app = new Appointment();
        app.setTitle("Bug 26842 Test");
        app.setStartDate(TimeTools.D("29.05.2013 08:00"));
        app.setEndDate(TimeTools.D("29.05.2013 08:00"));
        app.setParticipants(new Participant[0]);
        app.setParentFolderID(this.folder.getObjectID());
        app.setIgnoreConflicts(true);
        this.ctm.insert(app);
        Appointment appointment = this.ctm.get(app.getParentFolderID(), app.getObjectID());
        Bug26842Test.assertEquals((String)"Wrong participants.", (int)this.client.getValues().getUserId(), (int)appointment.getParticipants()[0].getIdentifier());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        this.ftm.cleanUp();
        super.tearDown();
    }
}

