/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AbstractAppointmentRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class Bug12099Test
extends AbstractAJAXSession {
    public Bug12099Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeriesChangedFromIsZero() throws Throwable {
        AJAXClient myClient = this.getClient();
        int folderId = myClient.getValues().getPrivateAppointmentFolder();
        TimeZone tz = myClient.getValues().getTimeZone();
        Appointment series = new Appointment();
        series.setTitle("Bug 12099 test");
        series.setParentFolderID(folderId);
        series.setIgnoreConflicts(true);
        GregorianCalendar calendar = new GregorianCalendar(tz);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        series.setStartDate(calendar.getTime());
        ((Calendar)calendar).add(10, 1);
        series.setEndDate(calendar.getTime());
        series.setRecurrenceType(1);
        series.setInterval(1);
        series.setOccurrence(2);
        AbstractAppointmentRequest request = new InsertRequest(series, tz);
        AbstractAJAXResponse response = myClient.execute(request);
        series.setObjectID(((CommonInsertResponse)response).getId());
        series.setLastModified(response.getTimestamp());
        try {
            request = new com.openexchange.ajax.appointment.action.DeleteRequest(series.getObjectID(), folderId, 1, series.getLastModified());
            response = (CommonDeleteResponse)((Object)myClient.execute(request));
            series.setLastModified(response.getTimestamp());
            request = new GetRequest(folderId, series.getObjectID());
            response = (GetResponse)((Object)myClient.execute(request));
            series.setLastModified(response.getTimestamp());
            Appointment test = ((GetResponse)response).getAppointment(tz);
            Bug12099Test.assertEquals((String)"Editor of appointment series must not be 0.", (int)myClient.getValues().getUserId(), (int)test.getModifiedBy());
        }
        finally {
            myClient.execute(new com.openexchange.ajax.appointment.action.DeleteRequest(series.getObjectID(), folderId, series.getLastModified()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeriesChangedFromIsZero2() throws Throwable {
        AJAXClient clientA = this.getClient();
        int userIdA = clientA.getValues().getUserId();
        AJAXClient clientB = new AJAXClient(AJAXClient.User.User2);
        FolderObject folder = Create.folder(1, "Folder to test bug 12099 - " + String.valueOf(System.currentTimeMillis()), 2, 1, Create.ocl(userIdA, false, true, 128, 128, 128, 128), Create.ocl(clientB.getValues().getUserId(), false, false, 128, 128, 128, 128));
        CommonInsertResponse response = clientA.execute(new com.openexchange.ajax.folder.actions.InsertRequest((API)EnumAPI.OX_OLD, folder));
        response.fillObject((DataObject)folder);
        Appointment appointment = new Appointment();
        try {
            AJAXClient clientC = new AJAXClient(AJAXClient.User.User3);
            int userIdC = clientC.getValues().getUserId();
            TimeZone tzB = clientB.getValues().getTimeZone();
            appointment.setTitle("Test for bug 12099");
            appointment.setParentFolderID(folder.getObjectID());
            appointment.setStartDate(new Date(TimeTools.getHour(0, tzB)));
            appointment.setEndDate(new Date(TimeTools.getHour(1, tzB)));
            appointment.setRecurrenceType(1);
            appointment.setInterval(1);
            appointment.setOccurrence(3);
            appointment.setParticipants(ParticipantTools.createParticipants(userIdA, userIdC));
            appointment.setIgnoreConflicts(true);
            InsertRequest request = new InsertRequest(appointment, tzB);
            AbstractAJAXResponse response2 = clientB.execute(request);
            ((CommonInsertResponse)response2).fillObject((DataObject)appointment);
            int calendarFolderC = clientC.getValues().getPrivateAppointmentFolder();
            com.openexchange.ajax.appointment.action.DeleteRequest request2 = new com.openexchange.ajax.appointment.action.DeleteRequest(appointment.getObjectID(), calendarFolderC, 2, appointment.getLastModified());
            CommonDeleteResponse response3 = clientC.execute(request2);
            appointment.setLastModified(response3.getTimestamp());
            GetRequest request22 = new GetRequest(folder.getObjectID(), appointment.getObjectID());
            response2 = clientB.execute(request22);
            Appointment test = ((GetResponse)response2).getAppointment(tzB);
            Bug12099Test.assertEquals((String)"Appointment modified badly updated.", (int)userIdC, (int)test.getModifiedBy());
        }
        finally {
            clientA.execute(new DeleteRequest((API)EnumAPI.OX_OLD, folder.getObjectID(), folder.getLastModified()));
        }
    }
}

