/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.action;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.AppointmentParserTools;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractInsertParser;
import org.json.JSONException;
import org.json.JSONObject;

public class InsertParser
extends AbstractInsertParser<AppointmentInsertResponse> {
    InsertParser(boolean failOnError) {
        super(failOnError);
    }

    @Override
    protected AppointmentInsertResponse instantiateResponse(Response response) {
        return new AppointmentInsertResponse(response);
    }

    @Override
    protected AppointmentInsertResponse createResponse(Response response) throws JSONException {
        AppointmentInsertResponse retval = this.instantiateResponse(response);
        JSONObject data = (JSONObject)response.getData();
        if (data != null) {
            if (data.has("id")) {
                int objectId = data.getInt("id");
                if (this.isFailOnError()) {
                    InsertParser.assertTrue((String)"Problem while inserting object.", (objectId > 0 ? 1 : 0) != 0);
                }
                retval.setId(objectId);
            } else if (data.has("conflicts")) {
                AppointmentParserTools.parseConflicts(data, retval);
            } else if (this.isFailOnError()) {
                InsertParser.fail((String)("Missing created object identifier: " + response.getJSON()));
            }
        }
        return retval;
    }
}

