/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.attach.actions.AttachRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.CommonObject;
import java.io.ByteArrayInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.AssertionFailedError;

public class AppointmentAttachmentTests
extends AbstractAJAXSession {
    private int folderId;
    private TimeZone tz;
    private Appointment appointment;
    private int attachmentId;
    private Date creationDate;

    public AppointmentAttachmentTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.folderId = this.client.getValues().getPrivateAppointmentFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.appointment = new Appointment();
        this.appointment.setTitle("Test appointment for testing attachments");
        Calendar calendar = TimeTools.createCalendar(this.tz);
        this.appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        this.appointment.setEndDate(calendar.getTime());
        this.appointment.setParentFolderID(this.folderId);
        this.appointment.setIgnoreConflicts(true);
        this.client.execute(new InsertRequest(this.appointment, this.tz)).fillAppointment(this.appointment);
        this.attachmentId = this.client.execute(new AttachRequest((CommonObject)this.appointment, "test.txt", new ByteArrayInputStream("Test".getBytes()), "text/plain")).getId();
        com.openexchange.ajax.attach.actions.GetResponse response = this.client.execute(new com.openexchange.ajax.attach.actions.GetRequest((CommonObject)this.appointment, this.attachmentId));
        long timestamp = response.getAttachment().getCreationDate().getTime();
        this.creationDate = new Date(timestamp - (long)this.tz.getOffset(timestamp));
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }

    public void testLastModifiedOfNewestAttachmentWithGet() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(this.appointment.getParentFolderID(), this.appointment.getObjectID()));
        this.appointment.setLastModified(response.getTimestamp());
        Appointment test = response.getAppointment(this.tz);
        AppointmentAttachmentTests.assertEquals((String)"Creation date of attachment does not match.", (Object)this.creationDate, (Object)test.getLastModifiedOfNewestAttachment());
    }

    public void testLastModifiedOfNewestAttachmentWithAll() throws Throwable {
        CommonAllResponse response = this.client.execute(new AllRequest(this.appointment.getParentFolderID(), new int[]{1, 105}, this.appointment.getStartDate(), this.appointment.getEndDate(), this.tz, true));
        this.appointment.setLastModified(response.getTimestamp());
        Appointment test = null;
        int objectIdPos = response.getColumnPos(1);
        int lastModifiedOfNewestAttachmentPos = response.getColumnPos(105);
        for (Object[] objA : response) {
            if (this.appointment.getObjectID() != ((Integer)objA[objectIdPos]).intValue()) continue;
            test = new Appointment();
            test.setLastModifiedOfNewestAttachment(new Date((Long)objA[lastModifiedOfNewestAttachmentPos]));
            break;
        }
        if (null == test) {
            throw new AssertionFailedError("Can not find the created appointment with an attachment.");
        }
        AppointmentAttachmentTests.assertEquals((String)"Creation date of attachment does not match.", (Object)this.creationDate, (Object)test.getLastModifiedOfNewestAttachment());
    }

    public void testLastModifiedOfNewestAttachmentWithList() throws Throwable {
        CommonListResponse response = this.client.execute(new ListRequest(ListIDs.l(new int[][]{{this.appointment.getParentFolderID(), this.appointment.getObjectID()}}), new int[]{1, 105}));
        this.appointment.setLastModified(response.getTimestamp());
        Appointment test = null;
        int objectIdPos = response.getColumnPos(1);
        int lastModifiedOfNewestAttachmentPos = response.getColumnPos(105);
        for (Object[] objA : response) {
            if (this.appointment.getObjectID() != ((Integer)objA[objectIdPos]).intValue()) continue;
            test = new Appointment();
            test.setLastModifiedOfNewestAttachment(new Date((Long)objA[lastModifiedOfNewestAttachmentPos]));
            break;
        }
        if (null == test) {
            throw new AssertionFailedError("Can not find the created appointment with an attachment.");
        }
        AppointmentAttachmentTests.assertEquals((String)"Creation date of attachment does not match.", (Object)this.creationDate, (Object)test.getLastModifiedOfNewestAttachment());
    }
}

