/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import com.openexchange.user.json.actions.AbstractUserAction;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="getAttribute", description="Get user attribute (available with v6.20).", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="ID of the user."), @Parameter(name="name", description="The attribute name.")}, responseDescription="Response without timestamp: A JSON object providing name and value of the requested attribute.")
public final class GetAttributeAction
extends AbstractUserAction {
    public static final String ACTION = "getAttribute";

    public GetAttributeAction(ServiceLookup services) {
        super(services);
    }

    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        try {
            int id = GetAttributeAction.checkIntParameter("id", request);
            String name = GetAttributeAction.checkStringParameter("name", request);
            UserService userService = (UserService)this.services.getService(UserService.class);
            String value = userService.getUserAttribute(name, id, session.getContext());
            JSONObject json = new JSONObject();
            json.put("name", (Object)name);
            json.put("value", (Object)value);
            return new AJAXRequestResult((Object)json);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

