/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.management.ManagementService;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.processing.ProcessorService;
import com.openexchange.processing.internal.ProcessorServiceImpl;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.session.SessionThreadCounter;
import com.openexchange.sessionCount.SessionThreadCounterImpl;
import com.openexchange.sessiond.SessiondEventConstants;
import com.openexchange.startup.CloseableControlService;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.behavior.CallerRunsBehavior;
import com.openexchange.threadpool.internal.ThreadPoolProperties;
import com.openexchange.threadpool.internal.ThreadPoolServiceImpl;
import com.openexchange.threadpool.osgi.ManagementServiceTrackerCustomizer;
import com.openexchange.threadpool.osgi.ManagementServiceTrackerCustomizer2;
import com.openexchange.threadpool.osgi.SessionThreadCountEventHandler;
import com.openexchange.timer.TimerService;
import com.openexchange.timer.internal.CustomThreadPoolExecutorTimerService;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolActivator
extends HousekeepingActivator {
    public static final AtomicReference<ThreadPoolService> REF_THREAD_POOL = new AtomicReference();
    public static final AtomicReference<TimerService> REF_TIMER = new AtomicReference();
    public static final AtomicReference<ProcessorService> REF_PROCESSOR = new AtomicReference();
    public static final AtomicReference<CloseableControlService> REF_CLOSEABLE_CONTROL = new AtomicReference();
    private volatile ThreadPoolServiceImpl threadPool;
    private volatile ProcessorServiceImpl processorService;

    protected void startBundle() throws Exception {
        final Logger LOG = LoggerFactory.getLogger(ThreadPoolActivator.class);
        try {
            ProcessorServiceImpl processorService;
            ThreadPoolServiceImpl threadPool;
            LOG.info("starting bundle: com.openexchange.threadpool");
            final BundleContext context = this.context;
            ConfigurationService confService = (ConfigurationService)this.getService(ConfigurationService.class);
            ThreadPoolProperties init = new ThreadPoolProperties().init(confService);
            this.threadPool = threadPool = ThreadPoolServiceImpl.newInstance(init);
            if (init.isPrestartAllCoreThreads()) {
                threadPool.prestartAllCoreThreads();
            }
            this.track(ManagementService.class, new ManagementServiceTrackerCustomizer(context, threadPool));
            this.track(CloseableControlService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<CloseableControlService, CloseableControlService>(){

                public CloseableControlService addingService(ServiceReference<CloseableControlService> reference) {
                    CloseableControlService closeableControl = (CloseableControlService)context.getService(reference);
                    REF_CLOSEABLE_CONTROL.set(closeableControl);
                    return null;
                }

                public void modifiedService(ServiceReference<CloseableControlService> reference, CloseableControlService service) {
                }

                public void removedService(ServiceReference<CloseableControlService> reference, CloseableControlService service) {
                    REF_CLOSEABLE_CONTROL.set(null);
                    context.ungetService(reference);
                }
            });
            REF_THREAD_POOL.set(threadPool);
            this.registerService(ThreadPoolService.class, threadPool);
            Hashtable<String, Object> dict = new Hashtable<String, Object>(4);
            ((Dictionary)dict).put("service.ranking", Integer.MAX_VALUE);
            ((Dictionary)dict).put("service.description", "The Open-Xchange ExecutorService");
            ((Dictionary)dict).put("service.vendor", "OX Software GmbH");
            this.registerService(ExecutorService.class, threadPool.getExecutor(), dict);
            CustomThreadPoolExecutorTimerService timerService = new CustomThreadPoolExecutorTimerService(threadPool.getThreadPoolExecutor());
            REF_TIMER.set(timerService);
            this.registerService(TimerService.class, timerService);
            this.processorService = processorService = new ProcessorServiceImpl();
            REF_PROCESSOR.set(processorService);
            this.registerService(ProcessorService.class, processorService);
            int notifyThreashold = confService.getIntProperty("com.openexchange.session.maxThreadNotifyThreshold", -1);
            SessionThreadCounterImpl counterImpl = new SessionThreadCounterImpl(notifyThreashold, (ServiceLookup)this);
            this.registerService(SessionThreadCounter.class, counterImpl);
            SessionThreadCounter.REFERENCE.set(counterImpl);
            SessionThreadCountEventHandler handler = new SessionThreadCountEventHandler(context, notifyThreashold, counterImpl);
            this.rememberTracker(handler);
            Hashtable<String, Object> dict2 = new Hashtable<String, Object>(1);
            ((Dictionary)dict2).put("event.topics", SessionThreadCounter.EVENT_TOPIC);
            this.registerService(EventHandler.class, (Object)handler, dict2);
            this.track(ManagementService.class, new ManagementServiceTrackerCustomizer2(context, counterImpl, handler));
            EventHandler sessionEventHandler = new EventHandler(){

                public void handleEvent(final Event event) {
                    AbstractTask<Void> task = new AbstractTask<Void>(){

                        @Override
                        public Void call() throws Exception {
                            try {
                                this.doHandleEvent(event);
                            }
                            catch (Exception e) {
                                LOG.warn("Handling event {} failed.", (Object)event.getTopic(), (Object)e);
                            }
                            return null;
                        }
                    };
                    threadPool.submit(task, CallerRunsBehavior.getInstance());
                }

                protected void doHandleEvent(Event event) {
                    block3: {
                        String topic;
                        block4: {
                            block2: {
                                topic = event.getTopic();
                                if (!"com/openexchange/sessiond/remove/data".equals(topic)) break block2;
                                Map container = (Map)event.getProperty("com.openexchange.sessiond.container");
                                for (Session session : container.values()) {
                                    this.removeFor(session);
                                }
                                break block3;
                            }
                            if (!"com/openexchange/sessiond/remove/session".equals(topic)) break block4;
                            this.removeFor((Session)event.getProperty("com.openexchange.sessiond.session"));
                            break block3;
                        }
                        if (!"com/openexchange/sessiond/remove/container".equals(topic)) break block3;
                        Map container = (Map)event.getProperty("com.openexchange.sessiond.container");
                        for (Session session : container.values()) {
                            this.removeFor(session);
                        }
                    }
                }

                private void removeFor(Session session) {
                    SessionThreadCounter threadCounter = (SessionThreadCounter)SessionThreadCounter.REFERENCE.get();
                    if (null != threadCounter) {
                        threadCounter.remove(session.getSessionID());
                    }
                }
            };
            dict2 = new Hashtable(1);
            ((Dictionary)dict2).put("event.topics", SessiondEventConstants.getAllTopics());
            this.registerService(EventHandler.class, sessionEventHandler, dict2);
            this.openTrackers();
        }
        catch (Exception e) {
            LOG.error("Failed start-up of bundle com.openexchange.threadpool", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopBundle() throws Exception {
        block8: {
            Logger LOG = LoggerFactory.getLogger(ThreadPoolActivator.class);
            try {
                ThreadPoolServiceImpl threadPool;
                LOG.info("stopping bundle: com.openexchange.threadpool");
                REF_THREAD_POOL.set(null);
                REF_TIMER.set(null);
                REF_PROCESSOR.set(null);
                this.cleanUp();
                SessionThreadCounter.REFERENCE.set(null);
                ProcessorServiceImpl processorService = this.processorService;
                if (null != processorService) {
                    this.processorService = null;
                    processorService.shutDownAll();
                }
                if (null == (threadPool = this.threadPool)) break block8;
                try {
                    threadPool.shutdownNow();
                    threadPool.awaitTermination(10000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.threadPool = null;
                }
            }
            catch (Exception e) {
                LOG.error("Failed shut-down of bundle com.openexchange.threadpool", (Throwable)e);
                throw e;
            }
        }
    }

    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class};
    }

    protected void handleAvailability(Class<?> clazz) {
        Logger LOG = LoggerFactory.getLogger(ThreadPoolActivator.class);
        LOG.info("Appeared service: {}", (Object)clazz.getName());
    }

    protected void handleUnavailability(Class<?> clazz) {
        Logger LOG = LoggerFactory.getLogger(ThreadPoolActivator.class);
        LOG.info("Disappeared service: {}", (Object)clazz.getName());
    }
}

