/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.threadpool.RefusedExecutionBehavior;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.internal.CustomFutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

public class ScalingQueue
extends LinkedBlockingQueue<Runnable> {
    private static final long serialVersionUID = 2967523498773168654L;
    private ThreadPoolExecutor executor;
    private ThreadPoolService threadPool;

    public ScalingQueue() {
    }

    public ScalingQueue(int capacity) {
        super(capacity);
    }

    public RejectedExecutionHandler createRejectedExecutionHandler(RejectedExecutionHandler defaultHandler) {
        return new ForceQueuePolicy(this, defaultHandler, this.threadPool);
    }

    public synchronized void setThreadPool(ThreadPoolService threadPool) {
        this.threadPool = threadPool;
    }

    public synchronized void setThreadPoolExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public boolean superOffer(Runnable o) {
        return super.offer(o);
    }

    @Override
    public boolean offer(Runnable o) {
        int allWorkingThreads = this.executor.getActiveCount() + super.size();
        return allWorkingThreads < this.executor.getPoolSize() && super.offer(o);
    }

    public static final class ForceQueuePolicy
    implements RejectedExecutionHandler {
        private final ScalingQueue queue;
        private final RejectedExecutionHandler defaultHandler;
        private final ThreadPoolService threadPool;

        public ForceQueuePolicy(ScalingQueue queue, RejectedExecutionHandler defaultHandler, ThreadPoolService threadPool) {
            this.queue = queue;
            this.defaultHandler = defaultHandler;
            this.threadPool = threadPool;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            block7: {
                try {
                    ScalingQueue scalingQueue = this.queue;
                    if (null == scalingQueue) {
                        executor.getQueue().put(r);
                        break block7;
                    }
                    if (scalingQueue.superOffer(r)) break block7;
                    if (r instanceof CustomFutureTask) {
                        CustomFutureTask cft = (CustomFutureTask)r;
                        try {
                            this.handleTask(cft);
                        }
                        catch (RejectedExecutionException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            cft.setException(e);
                        }
                    }
                    this.defaultHandler.rejectedExecution(r, executor);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RejectedExecutionException(e);
                }
            }
        }

        private <V> void handleTask(CustomFutureTask<V> cft) throws Exception {
            V result;
            RefusedExecutionBehavior<V> reb = cft.getRefusedExecutionBehavior();
            if (null != reb && RefusedExecutionBehavior.DISCARDED != (result = reb.refusedExecution(cft.getTask(), this.threadPool))) {
                cft.set(result);
            }
        }
    }
}

