/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessionCount;

import com.openexchange.server.ServiceLookup;
import com.openexchange.session.SessionThreadCounter;
import com.openexchange.session.ThreadCountEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public final class SessionThreadCounterImpl
implements SessionThreadCounter {
    private final ConcurrentMap<String, ThreadCountEntry> map;
    private final int notifyThreashold;
    private final ServiceLookup services;

    public SessionThreadCounterImpl(int notifyThreashold, ServiceLookup services) {
        this.services = services;
        this.notifyThreashold = notifyThreashold;
        this.map = new ConcurrentHashMap<String, ThreadCountEntry>(1024);
    }

    private ThreadCountEntry getCount(String sessionId) {
        ThreadCountEntry newCounter;
        ThreadCountEntry ret = (ThreadCountEntry)this.map.get(sessionId);
        if (null == ret && null == (ret = this.map.putIfAbsent(sessionId, newCounter = new ThreadCountEntry(sessionId)))) {
            ret = newCounter;
        }
        return ret;
    }

    public Map<String, Set<Thread>> getThreads(int threshold) {
        int limit = threshold >= 0 ? threshold : 0;
        LinkedList<ThreadCountEntry> list = new LinkedList<ThreadCountEntry>();
        for (ThreadCountEntry threadCountEntry : this.map.values()) {
            if (threadCountEntry.get() < limit) continue;
            list.add(threadCountEntry);
        }
        Collections.sort(list);
        Collections.reverse(list);
        LinkedHashMap<String, Set<Thread>> map = new LinkedHashMap<String, Set<Thread>>(list.size());
        for (ThreadCountEntry entry : list) {
            map.put(entry.getSessionId(), entry.getThreads());
        }
        return map;
    }

    public int increment(String sessionId) {
        EventAdmin eventAdmin;
        if (this.notifyThreashold <= 0) {
            return this.getCount(sessionId).incrementAndGet();
        }
        ThreadCountEntry entry = this.getCount(sessionId);
        int updated = entry.incrementAndGet();
        if (updated == this.notifyThreashold && null != (eventAdmin = (EventAdmin)this.services.getOptionalService(EventAdmin.class))) {
            HashMap<String, String> props = new HashMap<String, String>(2);
            props.put(EVENT_PROP_SESSION_ID, sessionId);
            props.put(EVENT_PROP_ENTRY, (String)entry);
            Event event = new Event(EVENT_TOPIC, props);
            eventAdmin.postEvent(event);
        }
        return updated;
    }

    public int decrement(String sessionId) {
        ThreadCountEntry ret = (ThreadCountEntry)this.map.get(sessionId);
        if (null == ret) {
            return 0;
        }
        return ret.decrementAndGet();
    }

    public void clear() {
        this.map.clear();
    }

    public void remove(String sessionId) {
        this.map.remove(sessionId);
    }
}

