/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceCollector;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OSGiSubscriptionSourceCollector
extends SubscriptionSourceCollector
implements ServiceTrackerCustomizer<SubscribeService, SubscribeService> {
    private final ServiceTracker<SubscribeService, SubscribeService> tracker;
    private final BundleContext context;
    private volatile boolean grabbedAll;

    public OSGiSubscriptionSourceCollector(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, SubscribeService.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabAll() {
        if (this.grabbedAll) {
            return;
        }
        OSGiSubscriptionSourceCollector oSGiSubscriptionSourceCollector = this;
        synchronized (oSGiSubscriptionSourceCollector) {
            if (this.grabbedAll) {
                return;
            }
            try {
                Collection serviceReferences = this.context.getServiceReferences(SubscribeService.class, null);
                if (serviceReferences != null) {
                    for (ServiceReference reference : serviceReferences) {
                        this.addingService(reference);
                    }
                }
                this.grabbedAll = true;
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.tracker.close();
    }

    public SubscribeService addingService(ServiceReference<SubscribeService> reference) {
        SubscribeService subscribeService = (SubscribeService)this.context.getService(reference);
        this.addSubscribeService(subscribeService);
        return subscribeService;
    }

    public void modifiedService(ServiceReference<SubscribeService> reference, SubscribeService service) {
    }

    public void removedService(ServiceReference<SubscribeService> reference, SubscribeService service) {
        this.removeSubscribeService(service.getSubscriptionSource().getId());
    }

    @Override
    public SubscriptionSource getSource(Context context, int subscriptionId) throws OXException {
        this.grabAll();
        return super.getSource(context, subscriptionId);
    }

    @Override
    public SubscriptionSource getSource(String identifier) {
        this.grabAll();
        return super.getSource(identifier);
    }

    @Override
    public List<SubscriptionSource> getSources(int folderModule) {
        this.grabAll();
        return super.getSources(folderModule);
    }

    @Override
    public boolean knowsSource(String identifier) {
        this.grabAll();
        return super.knowsSource(identifier);
    }
}

