/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum SubscriptionErrorMessage implements DisplayableOXExceptionCode
{
    SQLException(CATEGORY_ERROR, 1, "A SQL error occurred.", "Error while reading/writing data from/to the database."),
    ParseException(CATEGORY_ERROR, 2, "A parsing error occurred: %1$s."),
    IDGiven(CATEGORY_ERROR, 3, "Unable to save a given ID."),
    ParsingError(CATEGORY_ERROR, 6, "A parsing error occurred: %1$s."),
    SubscriptionNotFound(CATEGORY_USER_INPUT, 5, "Not able to find the requested subscription", "Cannot find the requested subscription."),
    INVALID_LOGIN(CATEGORY_USER_INPUT, 7, "Inserted login or password have been wrong.", "The login/password combination you entered is wrong."),
    COMMUNICATION_PROBLEM(CATEGORY_SERVICE_DOWN, 8, "Subscription or an involved service is currently not available.", "A required service is currently not available. Please try again later."),
    INVALID_WORKFLOW(CATEGORY_CONFIGURATION, 9, "The steps of the crawling workflow do not fit together."),
    INACTIVE_SOURCE(CATEGORY_CONFIGURATION, 10, "Cannot access subscription source.", "The source the subscription belongs to is currently inactive, and cannot provide data."),
    MISSING_ARGUMENT(CATEGORY_USER_INPUT, 11, "The argument %1$s is missing to process the subscription.", "The argument %1$s is missing."),
    PERMISSION_DENIED(CATEGORY_WARNING, 12, "User do not have appropriate permissions to complete the operation.", "You do not have the appropriate permissions to complete this operation."),
    EMAIL_ADDR_LOGIN(CATEGORY_TRY_AGAIN, 13, "The user has to specify full E-Mail address as login name.", "Please specify your full E-Mail address as login name."),
    IO_ERROR(CATEGORY_ERROR, 14, "An I/O error occurred: %1$s"),
    UNEXPECTED_ERROR(CATEGORY_ERROR, 9999, "An unexpected error occurred: %1$s."),
    NO_OAUTH_ACCOUNT_GIVEN(CATEGORY_USER_INPUT, 90111, "User does not have an OAuth-account to access this service.", "You need to create an OAuth-account first to access this service."),
    NEED_VERIFICATION(CATEGORY_USER_INPUT, 90112, "Your account needs to be verified: %1$s", "Your account needs to be verified: %1$s"),
    ABORT_IDENTITY_CONFIRMATION(CATEGORY_USER_INPUT, 90113, "The service provider asked for an identity confirmation. This happens for some accounts and cannot fixed by us. It is in the provider's responsibility. For this reason, the subscription cannot be completed.", "The service provider asked for an identity confirmation. This happens for some accounts and cannot fixed by us. It is in the provider's responsibility. For this reason, the subscription cannot be completed."),
    DUPLICATE_SUBSCRIPTION(CATEGORY_USER_INPUT, 90113, "You already have such a subscription.", "You already have such a subscription.");

    private static final String SQL_ERROR = "A SQL error occurred.";
    private static final String PARSING_ERROR = "A parsing error occurred: %1$s.";
    private static final String CANT_SAVE_ID = "Unable to save a given ID.";
    private static final String CANT_FIND_SUBSCRIPTION = "Not able to find the requested subscription";
    private static final String WRONG_PASSWORD = "Inserted login or password have been wrong.";
    private static final String SERVICE_UNAVAILABLE = "Subscription or an involved service is currently not available.";
    private static final String INCONSISTENT_WORKFLOW = "The steps of the crawling workflow do not fit together.";
    private static final String INACTIVE_SOURCE_MSG = "Cannot access subscription source.";
    private static final String MISSING_ARGUMENT_MSG = "The argument %1$s is missing to process the subscription.";
    private static final String PERMISSION_DENIED_MSG = "User do not have appropriate permissions to complete the operation.";
    private static final String EMAIL_ADDR_LOGIN_MSG = "The user has to specify full E-Mail address as login name.";
    private static final String UNEXPECTED_ERROR_MSG = "An unexpected error occurred: %1$s.";
    private static final String NO_OAUTH_ACCOUNT_GIVEN_MSG = "User does not have an OAuth-account to access this service.";
    private static final String PREFIX = "SUB";
    private final Category category;
    private final int errorCode;
    private final String message;
    private final String displayMessage;

    public static String prefix() {
        return PREFIX;
    }

    private SubscriptionErrorMessage(Category category, int errorCode, String message, String displayMessage) {
        this.category = category;
        this.errorCode = errorCode;
        this.message = message;
        this.displayMessage = displayMessage == null ? "An error occurred inside the server which prevented it from fulfilling the request." : displayMessage;
    }

    private SubscriptionErrorMessage(Category category, int errorCode, String message) {
        this(category, errorCode, message, null);
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

