/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.session.Session;
import com.openexchange.webdav.xml.CalendarParser;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AppointmentParser
extends CalendarParser {
    private static final Logger LOG = LoggerFactory.getLogger(AppointmentParser.class);

    public AppointmentParser(Session sessionObj) {
        this.sessionObj = sessionObj;
    }

    public void parse(XmlPullParser parser, Appointment appointmentobject) throws OXException, XmlPullParserException {
        try {
            while (parser.getEventType() != 3 || !parser.getName().equals("prop")) {
                this.parseElementAppointment(appointmentobject, parser);
                parser.nextTag();
            }
        }
        catch (XmlPullParserException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new OXException((Throwable)exc);
        }
    }

    protected void parseElementAppointment(Appointment ao, XmlPullParser parser) throws Exception {
        if (!this.hasCorrectNamespace(parser)) {
            LOG.trace("unknown namespace in tag: {}", (Object)parser.getName());
            parser.nextText();
            return;
        }
        if (this.isTag(parser, "shown_as")) {
            ao.setShownAs(this.getValueAsInt(parser));
            return;
        }
        if (this.isTag(parser, "deleteexceptions")) {
            try {
                String _s = this.getValue(parser);
                if (_s == null) {
                    return;
                }
                String[] _dates = _s.split(",");
                Date[] deleteExceptions = new Date[_dates.length];
                for (int a = 0; a < _dates.length; ++a) {
                    deleteExceptions[a] = this.parseString2Date(_dates[a]);
                }
                ao.setDeleteExceptions(deleteExceptions);
                return;
            }
            catch (Exception exc) {
                throw new OXException((Throwable)exc);
            }
        }
        if (this.isTag(parser, "full_time")) {
            ao.setFullTime(this.getValueAsBoolean(parser));
            return;
        }
        if (this.isTag(parser, "location")) {
            ao.setLocation(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "alarm")) {
            ao.setAlarm(this.getValueAsInt(parser));
            return;
        }
        if (this.isTag(parser, "alarm_flag")) {
            ao.setAlarmFlag(this.getValueAsBoolean(parser));
            return;
        }
        if (this.isTag(parser, "ignore_conflicts")) {
            ao.setIgnoreConflicts(this.getValueAsBoolean(parser));
            return;
        }
        if (this.isTag(parser, "uid")) {
            ao.setUid(this.getValue(parser));
        } else {
            this.parseElementCalendar(ao, parser);
        }
    }

    private Date parseString2Date(String s) {
        return new Date(Long.parseLong(s));
    }
}

