/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.contact.ContactService;
import com.openexchange.contact.internal.VCardUtil;
import com.openexchange.contact.vcard.VCardImport;
import com.openexchange.contact.vcard.VCardService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Streams;
import com.openexchange.login.Interface;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.webdav.PermissionServlet;
import com.openexchange.webdav.WebdavExceptionCode;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class vcard
extends PermissionServlet {
    private static final long serialVersionUID = 1043665340444383184L;
    private static final ContactField[] _contactFields = new ContactField[]{ContactField.OBJECT_ID, ContactField.CREATED_BY, ContactField.CREATION_DATE, ContactField.LAST_MODIFIED, ContactField.MODIFIED_BY, ContactField.FOLDER_ID, ContactField.PRIVATE_FLAG, ContactField.CATEGORIES, ContactField.GIVEN_NAME, ContactField.SUR_NAME, ContactField.ANNIVERSARY, ContactField.ASSISTANT_NAME, ContactField.BIRTHDAY, ContactField.BRANCHES, ContactField.BUSINESS_CATEGORY, ContactField.CATEGORIES, ContactField.CELLULAR_TELEPHONE1, ContactField.CELLULAR_TELEPHONE2, ContactField.CITY_BUSINESS, ContactField.CITY_HOME, ContactField.CITY_OTHER, ContactField.COMMERCIAL_REGISTER, ContactField.COMPANY, ContactField.COUNTRY_BUSINESS, ContactField.COUNTRY_HOME, ContactField.COUNTRY_OTHER, ContactField.DEPARTMENT, ContactField.DISPLAY_NAME, ContactField.EMAIL1, ContactField.EMAIL2, ContactField.EMAIL3, ContactField.EMPLOYEE_TYPE, ContactField.FAX_BUSINESS, ContactField.FAX_HOME, ContactField.FAX_OTHER, ContactField.FILE_AS, ContactField.FOLDER_ID, ContactField.GIVEN_NAME, ContactField.INFO, ContactField.INSTANT_MESSENGER1, ContactField.INSTANT_MESSENGER2, ContactField.MANAGER_NAME, ContactField.MARITAL_STATUS, ContactField.MIDDLE_NAME, ContactField.NICKNAME, ContactField.NOTE, ContactField.NUMBER_OF_CHILDREN, ContactField.NUMBER_OF_EMPLOYEE, ContactField.POSITION, ContactField.POSTAL_CODE_BUSINESS, ContactField.POSTAL_CODE_HOME, ContactField.POSTAL_CODE_OTHER, ContactField.PRIVATE_FLAG, ContactField.PROFESSION, ContactField.ROOM_NUMBER, ContactField.SALES_VOLUME, ContactField.SPOUSE_NAME, ContactField.STATE_BUSINESS, ContactField.STATE_HOME, ContactField.STATE_OTHER, ContactField.STREET_BUSINESS, ContactField.STREET_HOME, ContactField.STREET_OTHER, ContactField.SUFFIX, ContactField.TAX_ID, ContactField.TELEPHONE_ASSISTANT, ContactField.TELEPHONE_BUSINESS1, ContactField.TELEPHONE_BUSINESS2, ContactField.TELEPHONE_CALLBACK, ContactField.TELEPHONE_CAR, ContactField.TELEPHONE_COMPANY, ContactField.TELEPHONE_HOME1, ContactField.TELEPHONE_HOME2, ContactField.TELEPHONE_IP, ContactField.TELEPHONE_ISDN, ContactField.TELEPHONE_OTHER, ContactField.TELEPHONE_PAGER, ContactField.TELEPHONE_PRIMARY, ContactField.TELEPHONE_RADIO, ContactField.TELEPHONE_TELEX, ContactField.TELEPHONE_TTYTDD, ContactField.TITLE, ContactField.URL, ContactField.DEFAULT_ADDRESS, ContactField.VCARD_ID};
    private static final String STR_USER_AGENT = "user-agent";
    private static final String CONTACTFOLDER = "contactfolder";
    private static final String ENABLEDELETE = "enabledelete";
    private static String SQL_PRINCIPAL_SELECT = "SELECT object_id, contactfolder FROM vcard_principal WHERE cid = ? AND principal = ?";
    private static String SQL_PRINCIPAL_INSERT = "INSERT INTO vcard_principal (object_id, cid, principal, contactfolder) VALUES (?, ?, ?, ?)";
    private static String SQL_PRINCIPAL_UPDATE = "UPDATE vcard_principal SET contactfolder = ? WHERE object_id = ?";
    private static String SQL_ENTRIES_LOAD = "SELECT object_id, client_id, target_object_id FROM vcard_ids WHERE cid = ? AND principal_id = ?";
    private static String SQL_ENTRY_INSERT = "INSERT INTO vcard_ids (object_id, cid, principal_id, client_id, target_object_id) VALUES (?, ?, ?, ? ,?)";
    private static String SQL_ENTRY_DELETE = "DELETE FROM vcard_ids WHERE target_object_id = ? AND principal_id = ?";
    private static final transient Logger LOG = LoggerFactory.getLogger(vcard.class);

    public void oxinit() {
    }

    @Override
    protected Interface getInterface() {
        return Interface.WEBDAV_VCARD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOG.debug("GET");
        ServletOutputStream os = resp.getOutputStream();
        String user_agent = null;
        String principal = null;
        Session sessionObj = vcard.getSession(req);
        try {
            Context context = ContextStorage.getInstance().getContext(sessionObj.getContextId());
            resp.setStatus(200);
            user_agent = this.getUserAgent(req);
            principal = user_agent + '_' + sessionObj.getUserId();
            int contactfolder_id = this.getContactFolderID(req);
            if (contactfolder_id == 0) {
                contactfolder_id = new OXFolderAccess(context).getDefaultFolderID(sessionObj.getUserId(), 3);
            }
            int db_contactfolder_id = 0;
            int principal_id = 0;
            Map<Object, Object> entries_db = new HashMap(0);
            HashSet<String> entries = new HashSet<String>();
            Connection readCon = null;
            PreparedStatement principalStatement = null;
            ResultSet rs = null;
            boolean exists = false;
            try {
                readCon = DBPool.pickup(context);
                principalStatement = readCon.prepareStatement(SQL_PRINCIPAL_SELECT);
                principalStatement.setLong(1, context.getContextId());
                principalStatement.setString(2, principal);
                rs = principalStatement.executeQuery();
                exists = rs.next();
                if (exists) {
                    principal_id = rs.getInt(1);
                    db_contactfolder_id = rs.getInt(2);
                    entries_db = this.loadDBEntries(context, principal_id);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)principalStatement, readCon, true, context);
                throw throwable;
            }
            DBUtils.closeResources(rs, (Statement)principalStatement, readCon, true, context);
            try (SearchIterator<Contact> it = null;){
                resp.setStatus(200);
                resp.setContentType("text/vcard");
                ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
                it = contactService.getAllContacts(sessionObj, Integer.toString(contactfolder_id), _contactFields);
                while (it.hasNext()) {
                    Contact contactObject = (Contact)it.next();
                    VCardUtil.exportContact(contactObject, sessionObj, (OutputStream)os);
                    entries.add(Integer.toString(contactObject.getObjectID()));
                }
            }
            Connection writeCon = null;
            Statement ps = null;
            try {
                writeCon = DBPool.pickupWriteable(context);
                if (exists) {
                    if (db_contactfolder_id != contactfolder_id) {
                        ps = writeCon.prepareStatement(SQL_PRINCIPAL_UPDATE);
                        ps.setInt(1, principal_id);
                        ps.setInt(2, contactfolder_id);
                        ps.executeUpdate();
                        ps.close();
                    }
                } else {
                    writeCon.setAutoCommit(false);
                    principal_id = IDGenerator.getId(context, 75, writeCon);
                    writeCon.commit();
                    ps = writeCon.prepareStatement(SQL_PRINCIPAL_INSERT);
                    ps.setInt(1, principal_id);
                    ps.setLong(2, context.getContextId());
                    ps.setString(3, principal);
                    ps.setInt(4, contactfolder_id);
                    ps.executeUpdate();
                    ps.close();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
                if (writeCon != null) {
                    writeCon.setAutoCommit(true);
                    DBPool.pushWrite(context, writeCon);
                }
            }
            for (String s_object_id : entries) {
                if (entries_db.containsKey(s_object_id)) continue;
                this.addEntry(context, principal_id, Integer.parseInt(s_object_id), s_object_id);
            }
            Iterator<Object> databaseIterator = entries_db.keySet().iterator();
            while (databaseIterator.hasNext()) {
                String s_object_id;
                s_object_id = (String)entries_db.get(databaseIterator.next());
                if (entries.contains(s_object_id)) continue;
                this.deleteEntry(context, principal_id, Integer.parseInt(s_object_id));
            }
        }
        catch (OXException exc) {
            if (exc.isConflict()) {
                LOG.debug("doGet", (Throwable)exc);
                this.doError(resp, 409, exc.getMessage());
            } else {
                LOG.error("doGet", (Throwable)exc);
                this.doError(resp);
            }
        }
        catch (Exception exc) {
            LOG.error("doGet", (Throwable)exc);
            this.doError(resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOG.debug("PUT");
        String content_type = null;
        String client_id = null;
        ServletInputStream is = req.getInputStream();
        String user_agent = null;
        String principal = null;
        Session session = vcard.getSession(req);
        try {
            Map<String, String> entries_db;
            Context context = ContextStorage.getInstance().getContext(session.getContextId());
            resp.setStatus(200);
            user_agent = this.getUserAgent(req);
            content_type = req.getContentType();
            this.log("read vcard content_type: " + content_type);
            if (content_type == null) {
                content_type = "text/vcard";
            }
            if (user_agent == null) {
                throw WebdavExceptionCode.MISSING_HEADER_FIELD.create(STR_USER_AGENT);
            }
            principal = user_agent + '_' + session.getUserId();
            int contactfolder_id = this.getContactFolderID(req);
            if (contactfolder_id == 0) {
                contactfolder_id = new OXFolderAccess(context).getDefaultFolderID(session.getUserId(), 3);
            }
            if (contactfolder_id == 6) {
                resp.setContentType("text/html");
                resp.setStatus(409);
                PrintWriter pw = resp.getWriter();
                pw.println("folder internal users is only readable!");
                pw.flush();
                return;
            }
            HashSet<String> entries = new HashSet<String>();
            boolean enabledelete = this.getEnableDelete(req);
            boolean exists = false;
            int principal_id = 0;
            Connection readCon = null;
            PreparedStatement principalStatement = null;
            ResultSet rs = null;
            try {
                readCon = DBPool.pickup(context);
                principalStatement = readCon.prepareStatement(SQL_PRINCIPAL_SELECT);
                principalStatement.setLong(1, context.getContextId());
                principalStatement.setString(2, principal);
                rs = principalStatement.executeQuery();
                int db_contactfolder_id = 0;
                exists = rs.next();
                if (!exists) {
                    throw WebdavExceptionCode.NO_PRINCIPAL.create(principal);
                }
                principal_id = rs.getInt(1);
                db_contactfolder_id = rs.getInt(2);
                if (db_contactfolder_id != contactfolder_id) {
                    throw WebdavExceptionCode.NO_PRINCIPAL.create(principal);
                }
                entries_db = this.loadDBEntries(context, principal_id);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)principalStatement, readCon, true, context);
                throw throwable;
            }
            DBUtils.closeResources(rs, (Statement)principalStatement, readCon, true, context);
            VCardService vCardService = ServerServiceRegistry.getServize(VCardService.class, true);
            SearchIterator<VCardImport> searchIterator = null;
            Date timestamp = new Date();
            try {
                searchIterator = vCardService.importVCards((InputStream)is, vCardService.createParameters(session));
                while (searchIterator.hasNext()) {
                    int object_id = 0;
                    VCardImport vCardImport = null;
                    try {
                        ContactService contactService;
                        vCardImport = (VCardImport)searchIterator.next();
                        Contact contactObj = vCardImport.getContact();
                        client_id = contactObj.getUid();
                        if (contactObj.getObjectID() == 0) {
                            contactObj.setParentFolderID(contactfolder_id);
                        }
                        if (client_id != null && entries_db.containsKey(client_id)) {
                            try {
                                object_id = Integer.parseInt(entries_db.get(client_id));
                            }
                            catch (NumberFormatException exc) {
                                LOG.debug("object id is not an integer");
                            }
                            if (object_id > 0) {
                                contactObj.setObjectID(object_id);
                            }
                            contactObj.setParentFolderID(contactfolder_id);
                            contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
                            if (contactObj.containsObjectID()) {
                                contactService.updateContact(session, Integer.toString(contactfolder_id), Integer.toString(object_id), contactObj, timestamp);
                            } else {
                                contactService.createContact(session, Integer.toString(contactfolder_id), contactObj);
                            }
                            entries.add(client_id);
                        } else {
                            contactObj.setParentFolderID(contactfolder_id);
                            contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
                            if (contactObj.containsObjectID()) {
                                contactService.updateContact(session, Integer.toString(contactfolder_id), Integer.toString(contactObj.getObjectID()), contactObj, timestamp);
                            } else {
                                contactService.createContact(session, Integer.toString(contactfolder_id), contactObj);
                            }
                            if (client_id != null) {
                                entries.add(client_id);
                                this.addEntry(context, principal_id, contactObj.getObjectID(), client_id);
                            }
                        }
                        LOG.debug("STATUS: OK");
                    }
                    catch (OXException exc) {
                        if (!exc.isNotFound()) throw exc;
                        LOG.debug("object was already deleted on server: {}", (Object)object_id, (Object)exc);
                    }
                    finally {
                        Streams.close((Closeable)vCardImport);
                    }
                }
            }
            finally {
                SearchIterators.close(searchIterator);
            }
            for (Map.Entry<String, String> entry : entries_db.entrySet()) {
                String tmp = entry.getKey();
                if (entries.contains(tmp)) continue;
                int object_id = Integer.parseInt(entry.getValue());
                this.deleteEntry(context, principal_id, object_id);
                if (!enabledelete) continue;
                ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
                try {
                    contactService.deleteContact(session, Integer.toString(contactfolder_id), Integer.toString(object_id), timestamp);
                }
                catch (OXException exc) {
                    if (!exc.isNotFound()) throw exc;
                    LOG.debug("object was already deleted on server: {}", (Object)object_id, (Object)exc);
                    continue;
                    return;
                }
            }
        }
        catch (OXException exc) {
            if (exc.isNoPermission()) {
                LOG.debug("doPut", (Throwable)exc);
                this.doError(resp, 403, exc.getMessage());
                return;
            } else if (exc.isConflict()) {
                LOG.debug("doPut", (Throwable)exc);
                this.doError(resp, 409, exc.getMessage());
                return;
            } else {
                LOG.error("doPut", (Throwable)exc);
                this.doError(resp);
            }
            return;
        }
        catch (Exception exc) {
            LOG.error("doPut", (Throwable)exc);
            this.doError(resp);
        }
    }

    private void doError(HttpServletResponse resp) {
        this.doError(resp, 500, "Server Error");
    }

    private void doError(HttpServletResponse resp, int code, String msg) {
        this.log("ERROR: " + code + ": " + msg);
        resp.setStatus(code);
        resp.setContentType("text/html");
    }

    private String getUserAgent(HttpServletRequest req) throws OXException {
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String tmp = e.nextElement().toString().toLowerCase();
            if (!STR_USER_AGENT.equals(tmp)) continue;
            return req.getHeader(STR_USER_AGENT);
        }
        throw WebdavExceptionCode.MISSING_HEADER_FIELD.create(STR_USER_AGENT);
    }

    private int getContactFolderID(HttpServletRequest req) throws OXException {
        if (req.getParameter(CONTACTFOLDER) != null) {
            try {
                return Integer.parseInt(req.getParameter(CONTACTFOLDER));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.NOT_A_NUMBER.create(exc, CONTACTFOLDER);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadDBEntries(Context context, int principal_object_id) throws OXException, SQLException {
        HashMap<String, String> entries_db = new HashMap<String, String>();
        Connection readCon = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(context);
            ps = readCon.prepareStatement(SQL_ENTRIES_LOAD);
            ps.setInt(1, principal_object_id);
            ps.setLong(2, context.getContextId());
            rs = ps.executeQuery();
            while (rs.next()) {
                entries_db.put(rs.getString(2), Integer.toString(rs.getInt(3)));
            }
            rs.close();
            ps.close();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (readCon != null) {
                DBPool.push(context, readCon);
            }
        }
        return entries_db;
    }

    private boolean getEnableDelete(HttpServletRequest req) {
        return req.getParameter(ENABLEDELETE) != null && req.getParameter(ENABLEDELETE).toLowerCase().equals("yes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(Context context, int principal_id, int object_target_id, String client_id) throws OXException, SQLException {
        Connection writeCon = null;
        Statement ps = null;
        try {
            writeCon = DBPool.pickupWriteable(context);
            writeCon.setAutoCommit(false);
            int objectId = IDGenerator.getId(context, 75, writeCon);
            writeCon.commit();
            ps = writeCon.prepareStatement(SQL_ENTRY_INSERT);
            ps.setInt(1, objectId);
            ps.setLong(2, context.getContextId());
            ps.setInt(3, principal_id);
            ps.setString(4, client_id);
            ps.setInt(5, object_target_id);
            ps.executeUpdate();
            ps.close();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (writeCon != null) {
                writeCon.setAutoCommit(true);
                DBPool.pushWrite(context, writeCon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEntry(Context context, int principal_id, int object_target_id) throws OXException, SQLException {
        Connection writeCon = null;
        Statement ps = null;
        try {
            writeCon = DBPool.pickupWriteable(context);
            ps = writeCon.prepareStatement(SQL_ENTRY_DELETE);
            ps.setInt(1, object_target_id);
            ps.setInt(2, principal_id);
            ps.executeUpdate();
            ps.close();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (writeCon != null) {
                DBPool.pushWrite(context, writeCon);
            }
        }
    }

    @Override
    protected boolean hasModulePermission(Session sessionObj, Context ctx) {
        UserConfiguration uc = UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx);
        return uc.hasVCard() && uc.hasContact();
    }

    @Override
    protected void decrementRequests() {
    }

    @Override
    protected void incrementRequests() {
    }
}

