/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.helpers;

import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavMethod;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.helpers.PropertyMixin;
import com.openexchange.webdav.protocol.util.PropertySwitch;
import com.openexchange.webdav.protocol.util.Utils;
import com.openexchange.webdav.xml.WebdavLockWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractResource
implements WebdavResource {
    private static final WebdavMethod[] OPTIONS = new WebdavMethod[]{WebdavMethod.GET, WebdavMethod.PUT, WebdavMethod.DELETE, WebdavMethod.HEAD, WebdavMethod.OPTIONS, WebdavMethod.TRACE, WebdavMethod.PROPPATCH, WebdavMethod.PROPFIND, WebdavMethod.MOVE, WebdavMethod.COPY, WebdavMethod.LOCK, WebdavMethod.UNLOCK, WebdavMethod.REPORT, WebdavMethod.ACL, WebdavMethod.MKCALENDAR};
    protected List<PropertyMixin> mixins = new ArrayList<PropertyMixin>();

    public void includeProperties(PropertyMixin ... mixins) {
        for (PropertyMixin mixin : mixins) {
            this.mixins.add(mixin);
        }
    }

    protected void checkPath() throws WebdavProtocolException {
        this.checkParentExists(this.getUrl());
    }

    protected void checkParentExists(WebdavPath url) throws WebdavProtocolException {
        WebdavPath check = new WebdavPath(new String[0]);
        for (String comp : url) {
            check.append(url);
            if (check.equals(url)) break;
            WebdavResource res = this.getFactory().resolveResource(check);
            if (!res.exists()) {
                throw WebdavProtocolException.Code.FILE_NOT_FOUND.create(this.getUrl(), 409, res.getUrl());
            }
            if (res.isCollection()) continue;
            throw WebdavProtocolException.Code.FILE_IS_DIRECTORY.create(this.getUrl(), 409, res.getUrl());
        }
    }

    @Override
    public void putBody(InputStream body) throws WebdavProtocolException {
        this.putBody(body, false);
    }

    @Override
    public void putBodyAndGuessLength(InputStream body) throws WebdavProtocolException {
        this.putBody(body, true);
    }

    @Override
    public String getResourceType() throws WebdavProtocolException {
        return null;
    }

    @Override
    public WebdavResource move(WebdavPath string) throws WebdavProtocolException {
        return this.move(string, false, true);
    }

    @Override
    public WebdavResource copy(WebdavPath string) throws WebdavProtocolException {
        return this.copy(string, false, true);
    }

    @Override
    public WebdavResource reload() throws WebdavProtocolException {
        return this.getFactory().resolveResource(this.getUrl());
    }

    @Override
    public WebdavResource move(WebdavPath dest, boolean noroot, boolean overwrite) throws WebdavProtocolException {
        WebdavResource copy = this.copy(dest);
        this.delete();
        ((AbstractResource)copy).setCreationDate(this.getCreationDate());
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebdavResource copy(WebdavPath dest, boolean noroot, boolean overwrite) throws WebdavProtocolException {
        AbstractResource clone = this.instance(dest);
        if (this.hasBody()) {
            InputStream body = this.getBody();
            try {
                clone.putBody(body);
            }
            finally {
                Streams.close((Closeable)body);
            }
        }
        for (WebdavProperty prop : this.getAllProps()) {
            clone.putProperty(prop);
        }
        clone.create();
        return clone;
    }

    public AbstractResource instance(WebdavPath dest) throws WebdavProtocolException {
        return (AbstractResource)this.getFactory().resolveResource(dest);
    }

    @Override
    public void removeProperty(String namespace, String name) throws WebdavProtocolException {
        this.internalRemoveProperty(namespace, name);
    }

    @Override
    public void putProperty(WebdavProperty prop) throws WebdavProtocolException {
        if (this.handleSpecialPut(prop)) {
            return;
        }
        this.internalPutProperty(prop);
    }

    @Override
    public WebdavProperty getProperty(String namespace, String name) throws WebdavProtocolException {
        WebdavProperty prop = this.handleSpecialGet(namespace, name);
        if (prop != null) {
            return prop;
        }
        prop = this.getFromMixin(namespace, name);
        if (prop != null) {
            return prop;
        }
        return this.internalGetProperty(namespace, name);
    }

    @Override
    public List<WebdavProperty> getAllProps() throws WebdavProtocolException {
        ArrayList<WebdavProperty> props = new ArrayList<WebdavProperty>(this.internalGetAllProps());
        props.addAll(this.getAllFromMixin());
        for (Protocol.Property p : this.getFactory().getProtocol().getKnownProperties()) {
            WebdavProperty prop = this.getProperty(p.getNamespace(), p.getName());
            if (prop == null) continue;
            props.add(prop);
        }
        return props;
    }

    protected List<WebdavProperty> getAllFromMixin() throws WebdavProtocolException {
        ArrayList<WebdavProperty> allProps = new ArrayList<WebdavProperty>();
        for (PropertyMixin mixin : this.mixins) {
            List<WebdavProperty> properties;
            try {
                properties = mixin.getAllProperties();
            }
            catch (OXException e) {
                if (e instanceof WebdavProtocolException) {
                    throw (WebdavProtocolException)e;
                }
                throw new WebdavProtocolException(this.getUrl(), 500, e);
            }
            allProps.addAll(properties);
        }
        return allProps;
    }

    protected WebdavProperty getFromMixin(String namespace, String name) throws WebdavProtocolException {
        for (PropertyMixin mixin : this.mixins) {
            WebdavProperty property;
            try {
                property = mixin.getProperty(namespace, name);
            }
            catch (OXException e) {
                if (e instanceof WebdavProtocolException) {
                    throw (WebdavProtocolException)e;
                }
                throw new WebdavProtocolException(this.getUrl(), 500, e);
            }
            if (property == null) continue;
            return property;
        }
        return null;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isLockNull() {
        return false;
    }

    @Override
    public WebdavMethod[] getOptions() {
        return OPTIONS;
    }

    @Override
    public WebdavCollection toCollection() {
        throw new IllegalStateException("This resource is no collection");
    }

    protected void addParentLocks(List<WebdavLock> lockList) throws WebdavProtocolException {
        for (WebdavResource webdavResource : this.parents()) {
            for (WebdavLock lock : webdavResource.getOwnLocks()) {
                if (!lock.locks(webdavResource, this)) continue;
                lockList.add(lock);
            }
        }
    }

    protected WebdavLock findParentLock(String token) throws WebdavProtocolException {
        for (WebdavResource webdavResource : this.parents()) {
            WebdavLock lock = webdavResource.getOwnLock(token);
            if (null == lock || !lock.locks(webdavResource, this)) continue;
            return lock;
        }
        return null;
    }

    protected WebdavCollection parent() throws WebdavProtocolException {
        return this.getFactory().resolveCollection(this.getUrl().parent());
    }

    protected List<WebdavCollection> parents() throws WebdavProtocolException {
        ArrayList<WebdavCollection> parents = new ArrayList<WebdavCollection>();
        WebdavPath path = new WebdavPath(new String[0]);
        for (String comp : this.getUrl()) {
            path.append(comp);
            if (path.equals(this.getUrl())) break;
            WebdavCollection res = this.getFactory().resolveCollection(path);
            parents.add(res);
        }
        return parents;
    }

    protected boolean handleSpecialPut(WebdavProperty prop) throws WebdavProtocolException {
        Protocol.Property p = this.getFactory().getProtocol().get(prop.getNamespace(), prop.getName());
        if (p == null) {
            return false;
        }
        SpecialSetSwitch setter = this.getSetSwitch(prop.getValue());
        return (Boolean)p.doSwitch(setter);
    }

    protected SpecialSetSwitch getSetSwitch(String value) {
        return new SpecialSetSwitch(value);
    }

    protected WebdavProperty handleSpecialGet(String namespace, String name) throws WebdavProtocolException {
        Protocol.Property p = this.getFactory().getProtocol().get(namespace, name);
        if (p == null) {
            return null;
        }
        if (!this.isset(p)) {
            return null;
        }
        String value = (String)p.doSwitch(this.getGetSwitch(this));
        WebdavProperty retVal = p.getWebdavProperty();
        retVal.setValue(value);
        switch (p.getId()) {
            case 8: 
            case 9: 
            case 10: {
                retVal.setXML(true);
                break;
            }
            default: {
                retVal.setXML(false);
            }
        }
        return retVal;
    }

    protected PropertySwitch getGetSwitch(AbstractResource resource) {
        return new SpecialGetSwitch();
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof WebdavResource) {
            WebdavResource res = (WebdavResource)o;
            return res.getUrl().equals(this.getUrl());
        }
        return false;
    }

    public String toString() {
        return this.getUrl().toString();
    }

    @Override
    public Protocol getProtocol() {
        return this.getFactory().getProtocol();
    }

    public abstract void putBody(InputStream var1, boolean var2) throws WebdavProtocolException;

    public abstract boolean hasBody() throws WebdavProtocolException;

    public abstract void setCreationDate(Date var1) throws WebdavProtocolException;

    protected abstract List<WebdavProperty> internalGetAllProps() throws WebdavProtocolException;

    protected abstract WebdavFactory getFactory();

    protected abstract void internalPutProperty(WebdavProperty var1) throws WebdavProtocolException;

    protected abstract void internalRemoveProperty(String var1, String var2) throws WebdavProtocolException;

    protected abstract WebdavProperty internalGetProperty(String var1, String var2) throws WebdavProtocolException;

    protected abstract boolean isset(Protocol.Property var1);

    public class SpecialSetSwitch
    implements PropertySwitch {
        protected final String value;

        public SpecialSetSwitch(String value) {
            this.value = value;
        }

        @Override
        public Object creationDate() throws WebdavProtocolException {
            return Boolean.TRUE;
        }

        @Override
        public Object displayName() throws WebdavProtocolException {
            AbstractResource.this.setDisplayName(this.value);
            return Boolean.TRUE;
        }

        @Override
        public Object contentLanguage() throws WebdavProtocolException {
            AbstractResource.this.setLanguage(this.value);
            return Boolean.TRUE;
        }

        @Override
        public Object contentLength() throws WebdavProtocolException {
            AbstractResource.this.setLength(new Long(this.value));
            return Boolean.TRUE;
        }

        @Override
        public Object contentType() throws WebdavProtocolException {
            AbstractResource.this.setContentType(this.value);
            return Boolean.TRUE;
        }

        @Override
        public Object etag() throws WebdavProtocolException {
            return Boolean.TRUE;
        }

        @Override
        public Object lastModified() throws WebdavProtocolException {
            return Boolean.TRUE;
        }

        @Override
        public Object resourceType() throws WebdavProtocolException {
            return Boolean.TRUE;
        }

        @Override
        public Object lockDiscovery() throws WebdavProtocolException {
            return Boolean.TRUE;
        }

        @Override
        public Object supportedLock() throws WebdavProtocolException {
            return Boolean.TRUE;
        }

        @Override
        public Object source() throws WebdavProtocolException {
            AbstractResource.this.setSource(this.value);
            return Boolean.TRUE;
        }
    }

    public class SpecialGetSwitch
    implements PropertySwitch {
        @Override
        public Object creationDate() throws WebdavProtocolException {
            return Utils.convert(AbstractResource.this.getCreationDate());
        }

        @Override
        public Object displayName() throws WebdavProtocolException {
            return AbstractResource.this.getDisplayName();
        }

        @Override
        public Object contentLanguage() throws WebdavProtocolException {
            return AbstractResource.this.getLanguage();
        }

        @Override
        public Object contentLength() throws WebdavProtocolException {
            Long l = AbstractResource.this.getLength();
            if (l == null) {
                return null;
            }
            return l.toString();
        }

        @Override
        public Object contentType() throws WebdavProtocolException {
            return AbstractResource.this.getContentType();
        }

        @Override
        public Object etag() throws WebdavProtocolException {
            return AbstractResource.this.getETag();
        }

        @Override
        public Object lastModified() throws WebdavProtocolException {
            return Utils.convert(AbstractResource.this.getLastModified());
        }

        @Override
        public Object resourceType() throws WebdavProtocolException {
            return AbstractResource.this.getResourceType();
        }

        @Override
        public Object lockDiscovery() throws WebdavProtocolException {
            StringBuffer activeLocks = new StringBuffer();
            WebdavLockWriter writer = new WebdavLockWriter();
            for (WebdavLock lock : AbstractResource.this.getLocks()) {
                activeLocks.append(writer.lock2xml(lock));
            }
            return activeLocks.toString();
        }

        @Override
        public Object supportedLock() throws WebdavProtocolException {
            return "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
        }

        @Override
        public Object source() throws WebdavProtocolException {
            return AbstractResource.this.getSource();
        }
    }
}

