/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavResource;

public class WebdavLock {
    public static final long NEVER = -1L;
    private Type type;
    private Scope scope;
    private int depth;
    private String owner;
    private long expires;
    private boolean neverExpires;
    private String token;
    private final long creationTime = System.currentTimeMillis();
    private int ownerID;

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public long getTimeout() {
        if (this.neverExpires) {
            return -1L;
        }
        long timeout = this.expires - System.currentTimeMillis();
        if (timeout < 0L) {
            return 0L;
        }
        return timeout;
    }

    public void setTimeout(long timeout) {
        if (timeout == -1L) {
            this.neverExpires = true;
            return;
        }
        this.neverExpires = false;
        this.expires = this.creationTime + timeout;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getOwnerID() {
        return this.ownerID;
    }

    public void setOwnerID(int ownerID) {
        this.ownerID = ownerID;
    }

    public boolean locks(WebdavResource locked, WebdavResource resource) {
        WebdavPath urlLocked = locked.getUrl();
        WebdavPath urlRes = resource.getUrl();
        if (!urlRes.startsWith(urlLocked)) {
            return false;
        }
        if (this.depth == -1) {
            return true;
        }
        if (this.depth == 0) {
            return urlLocked.equals(urlRes);
        }
        if (this.depth == 1) {
            return urlLocked.equals(urlRes.parent());
        }
        return false;
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof WebdavLock) {
            WebdavLock otherLock = (WebdavLock)other;
            return otherLock.token.equals(this.token);
        }
        return false;
    }

    public boolean isActive(long time) {
        return this.getTimeout() != 0L;
    }

    public static enum Scope {
        EXCLUSIVE_LITERAL,
        SHARED_LITERAL;

    }

    public static enum Type {
        WRITE_LITERAL;

    }
}

