/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.groupware.infostore.webdav.InfostoreWebdavFactory;
import com.openexchange.java.Strings;
import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavProtocolException;

public class WebdavUnlockAction
extends AbstractAction {
    @Override
    public void perform(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        String token = this.getToken(req.getHeader("Lock-Token"));
        if (Strings.isEmpty((String)token)) {
            throw WebdavProtocolException.generalError(req.getUrl(), 400);
        }
        WebdavLock lock = req.getResource().getLock(token);
        if (null == lock) {
            throw WebdavProtocolException.generalError(req.getUrl(), 412);
        }
        if (null != lock && WebdavLock.Scope.EXCLUSIVE_LITERAL.equals((Object)lock.getScope())) {
            WebdavLock ownLock = req.getResource().getOwnLock(token);
            if (null == ownLock) {
                throw WebdavProtocolException.generalError(req.getUrl(), 401);
            }
            if (0 < ownLock.getOwnerID()) {
                InfostoreWebdavFactory factory = (InfostoreWebdavFactory)req.getFactory();
                int currentUserID = factory.getSessionHolder().getSessionObject().getUserId();
                if (ownLock.getOwnerID() != currentUserID && factory.getSessionHolder().getContext().getMailadmin() != currentUserID) {
                    throw WebdavProtocolException.generalError(req.getUrl(), 401);
                }
            }
        }
        req.getResource().unlock(token);
        res.setStatus(200);
    }

    private String getToken(String header) {
        return header.substring(1, header.length() - 1);
    }
}

