/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdavRequestCycleAction
extends AbstractAction {
    private static final Logger LOG = LoggerFactory.getLogger(WebdavRequestCycleAction.class);

    @Override
    public void perform(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        req.getFactory().beginRequest();
        boolean stopped = false;
        try {
            this.yield(req, res);
            req.getFactory().endRequest(200);
            stopped = true;
        }
        catch (WebdavProtocolException x) {
            LOG.debug("Got Webdav Exception", (Throwable)((Object)x));
            req.getFactory().endRequest(x.getStatus());
            stopped = true;
            throw x;
        }
        finally {
            if (!stopped) {
                req.getFactory().endRequest(500);
            }
        }
    }
}

