/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.action.behaviour.BehaviourLookup;
import com.openexchange.webdav.action.ifheader.IfHeader;
import com.openexchange.webdav.action.ifheader.IfHeaderApply;
import com.openexchange.webdav.action.ifheader.IfHeaderEntity;
import com.openexchange.webdav.action.ifheader.IfHeaderList;
import com.openexchange.webdav.action.ifheader.IfHeaderParseException;
import com.openexchange.webdav.action.ifheader.StandardIfHeaderApply;
import com.openexchange.webdav.loader.LoadingHints;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdavIfAction
extends AbstractAction {
    private static final Logger LOG = LoggerFactory.getLogger(WebdavIfAction.class);
    private static final IfHeaderApply STANDARD_APPLY = new StandardIfHeaderApply();
    private int defaultDepth;
    private boolean checkSourceLocks;
    private boolean checkDestinationLocks;

    public WebdavIfAction() {
    }

    public WebdavIfAction(int defaultDepth, boolean checkSourceLocks, boolean checkDestinationLocks) {
        this.defaultDepth = defaultDepth;
        this.checkSourceLocks = checkSourceLocks;
        this.checkDestinationLocks = checkDestinationLocks;
    }

    public WebdavIfAction(boolean checkSourceLocks, boolean checkDestinationLocks) {
        this(0, checkSourceLocks, checkDestinationLocks);
    }

    @Override
    public void perform(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        int depth = this.getDepth(req);
        try {
            IfHeader ifHeader = req.getIfHeader();
            if (ifHeader != null) {
                this.rememberMentionedLocks(req, ifHeader);
                this.checkIfs(ifHeader, req, depth);
            }
            ArrayList<LoadingHints> lockHints = new ArrayList<LoadingHints>();
            if (this.checkSourceLocks) {
                lockHints.add(this.preloadSourceLocks(req, depth));
            }
            if (this.checkDestinationLocks) {
                lockHints.add(this.preloadDestinationLocks(req));
            }
            this.preLoad(lockHints);
            if (this.checkSourceLocks) {
                this.checkNeededLocks(ifHeader, req, depth);
            }
            if (this.checkDestinationLocks || req.getResource().isLockNull()) {
                this.checkDestinationLocks(ifHeader, req);
            }
        }
        catch (IfHeaderParseException e) {
            LOG.trace("", (Throwable)e);
        }
        this.yield(req, res);
    }

    private void rememberMentionedLocks(WebdavRequest req, IfHeader ifHeader) {
        LinkedList<String> mentionedLocks = new LinkedList<String>();
        for (IfHeaderList list : ifHeader.getLists()) {
            for (IfHeaderEntity entity : list) {
                if (!entity.isLockToken()) continue;
                mentionedLocks.add(entity.getPayload());
            }
        }
        req.getUserInfo().put("mentionedLocks", mentionedLocks);
    }

    private LoadingHints preloadDestinationLocks(WebdavRequest req) {
        LoadingHints loadingHints = new LoadingHints();
        loadingHints.setUrl(req.getDestinationUrl());
        loadingHints.setDepth(0);
        loadingHints.setProps(LoadingHints.Property.NONE);
        loadingHints.loadLocks(true);
        return loadingHints;
    }

    private LoadingHints preloadSourceLocks(WebdavRequest req, int depth) {
        LoadingHints loadingHints = new LoadingHints();
        loadingHints.setUrl(req.getUrl());
        loadingHints.setDepth(depth);
        loadingHints.setProps(LoadingHints.Property.NONE);
        loadingHints.loadLocks(true);
        return loadingHints;
    }

    private void checkDestinationLocks(IfHeader ifHeader, WebdavRequest req) throws WebdavProtocolException {
        if (null == req.getDestinationUrl()) {
            return;
        }
        WebdavResource destination = req.getDestination();
        if (null == destination) {
            return;
        }
        HashSet<String> locks = new HashSet<String>();
        for (WebdavLock lock : destination.getLocks()) {
            locks.add(lock.getToken());
        }
        this.removeProvidedLocks(ifHeader, locks);
        if (!locks.isEmpty()) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 423);
        }
    }

    private void checkNeededLocks(IfHeader ifHeader, WebdavRequest req, int depth) throws WebdavProtocolException {
        WebdavResource res = req.getResource();
        Iterable<Object> iter = null;
        iter = res.isCollection() ? res.toCollection().toIterable(depth) : Collections.emptyList();
        HashSet<String> neededLocks = new HashSet<String>();
        for (WebdavResource webdavResource : iter) {
            this.addLocks(neededLocks, webdavResource);
        }
        this.addLocks(neededLocks, res);
        this.removeProvidedLocks(ifHeader, neededLocks);
        if (!neededLocks.isEmpty()) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 423);
        }
    }

    private void removeProvidedLocks(IfHeader ifHeader, Set<String> neededLocks) {
        if (null == ifHeader) {
            return;
        }
        for (IfHeaderList list : ifHeader.getLists()) {
            for (IfHeaderEntity entity : list) {
                if (!entity.isLockToken()) continue;
                neededLocks.remove(entity.getPayload());
            }
        }
    }

    private void addLocks(Set<String> neededLocks, WebdavResource res) throws WebdavProtocolException {
        for (WebdavLock lock : res.getLocks()) {
            neededLocks.add(lock.getToken());
        }
    }

    private void checkIfs(IfHeader ifHeader, WebdavRequest req, int depth) throws WebdavProtocolException {
        LoadingHints loadingHints = new LoadingHints();
        loadingHints.setUrl(req.getUrl());
        loadingHints.setDepth(depth);
        loadingHints.setProps(LoadingHints.Property.SOME);
        loadingHints.addProperty("DAV:", "getetag");
        loadingHints.loadLocks(true);
        this.preLoad(loadingHints);
        WebdavResource res = req.getResource();
        Iterable<Object> iter = null;
        iter = res.isCollection() ? res.toCollection().toIterable(depth) : Collections.emptyList();
        for (WebdavResource resource : iter) {
            if (this.checkList(ifHeader, resource, req)) continue;
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 412);
        }
        if (this.checkList(ifHeader, res, req)) {
            return;
        }
        throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 412);
    }

    private boolean checkList(IfHeader ifHeader, WebdavResource resource, WebdavRequest req) throws WebdavProtocolException {
        List<IfHeaderList> relevant = ifHeader.getRelevant(req.getURLPrefix() + resource.getUrl());
        for (IfHeaderList list : relevant) {
            if (!this.matches(list, resource)) continue;
            return true;
        }
        return relevant.isEmpty();
    }

    private boolean matches(IfHeaderList list, WebdavResource resource) throws WebdavProtocolException {
        for (IfHeaderEntity entity : list) {
            IfHeaderApply apply = this.getApply();
            if (apply.matches(entity, resource)) continue;
            return false;
        }
        return true;
    }

    private IfHeaderApply getApply() {
        IfHeaderApply apply = BehaviourLookup.getInstance().get(IfHeaderApply.class);
        if (apply != null) {
            return apply;
        }
        return STANDARD_APPLY;
    }

    private int getDepth(WebdavRequest req) throws WebdavProtocolException {
        if (!req.getResource().isCollection()) {
            return 0;
        }
        String depth = req.getHeader("Depth");
        return depth == null ? this.defaultDepth : (depth.equalsIgnoreCase("Infinity") ? -1 : Integer.parseInt(depth));
    }

    public void setDefaultDepth(int i) {
        this.defaultDepth = i;
    }

    public void checkSourceLocks(boolean b) {
        this.checkSourceLocks = b;
    }

    public void checkDestinationLocks(boolean b) {
        this.checkDestinationLocks = b;
    }
}

