/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.update;

import java.util.ArrayList;
import java.util.List;

final class ForeignKey {
    private final String name;
    private final String primaryTable;
    private final String foreignTable;
    private final List<String> primaryColumns = new ArrayList<String>();
    private final List<String> foreignColumns = new ArrayList<String>();

    public ForeignKey(String name, String primaryTable, String foreignTable) {
        this.name = name;
        this.primaryTable = primaryTable;
        this.foreignTable = foreignTable;
    }

    public ForeignKey(String name, String primaryTable, String[] primaryColumns, String foreignTable, String[] foreignColumns) {
        this(name, primaryTable, foreignTable);
        for (int i = 0; i < primaryColumns.length; ++i) {
            this.setPrimaryColumn(i, primaryColumns[i]);
            this.setForeignColumn(i, foreignColumns[i]);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPrimaryTable() {
        return this.primaryTable;
    }

    public String getForeignTable() {
        return this.foreignTable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.primaryTable.hashCode();
        result = 31 * result + this.foreignTable.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForeignKey other = (ForeignKey)obj;
        return this.name.equals(other.name) && this.primaryTable.equals(other.primaryTable) && this.foreignTable.equals(other.foreignTable) && this.primaryColumns.equals(other.primaryColumns) && this.foreignColumns.equals(other.foreignColumns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FK ");
        sb.append(this.name);
        sb.append(' ');
        sb.append(this.foreignTable);
        sb.append(' ');
        sb.append(this.foreignColumns);
        sb.append(" references ");
        sb.append(this.primaryTable);
        sb.append(' ');
        sb.append(this.primaryColumns);
        return sb.toString();
    }

    public void setPrimaryColumn(int columnPos, String primaryColumn) {
        while (this.primaryColumns.size() <= columnPos) {
            this.primaryColumns.add(null);
        }
        this.primaryColumns.set(columnPos, primaryColumn);
    }

    public void setForeignColumn(int columnPos, String foreignColumn) {
        while (this.foreignColumns.size() <= columnPos) {
            this.foreignColumns.add(null);
        }
        this.foreignColumns.set(columnPos, foreignColumn);
    }

    public boolean isSame(ForeignKey other) {
        return null != other && this.name.equals(other.name) && this.primaryTable.equals(other.primaryTable) && this.foreignTable.equals(other.foreignTable);
    }

    public boolean matches(String[] otherPrimaryColumns, String[] otherForeignColumns) {
        boolean matches = this.primaryColumns.size() == this.foreignColumns.size() && this.primaryColumns.size() == otherPrimaryColumns.length && this.foreignColumns.size() == otherForeignColumns.length;
        for (int i = 0; matches && i < this.primaryColumns.size(); ++i) {
            matches = this.primaryColumns.get(i).equals(otherPrimaryColumns[i]) && this.foreignColumns.get(i).equals(otherForeignColumns[i]);
        }
        return matches;
    }
}

