/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.ratelimit;

import com.openexchange.tools.servlet.ratelimit.KeyPartProvider;
import com.openexchange.tools.servlet.ratelimit.RateLimiter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public final class Key {
    private static final String USER_AGENT = "User-Agent";
    private final int remotePort;
    private final String remoteAddr;
    private final String userAgent;
    private final List<String> parts;
    private final int hash;

    private static int hashCode(List<String> l) {
        if (l == null) {
            return 0;
        }
        int result = 1;
        for (String str : l) {
            result = 31 * result + (str == null ? 0 : str.hashCode());
        }
        return result;
    }

    public Key(HttpServletRequest servletRequest) {
        this(servletRequest, servletRequest.getHeader(USER_AGENT));
    }

    public Key(HttpServletRequest servletRequest, String userAgent) {
        this(RateLimiter.considerRemotePort() ? servletRequest.getRemotePort() : 0, servletRequest.getRemoteAddr(), userAgent, Key.extractParts(servletRequest));
    }

    public Key(HttpServletRequest servletRequest, String userAgent, String ... parts) {
        this(RateLimiter.considerRemotePort() ? servletRequest.getRemotePort() : 0, servletRequest.getRemoteAddr(), userAgent, null == parts || 0 == parts.length ? null : Arrays.asList(parts));
    }

    Key(int remotePort, String remoteAddr, String userAgent, List<String> parts) {
        this.remotePort = remotePort;
        this.remoteAddr = remoteAddr;
        this.userAgent = userAgent;
        this.parts = parts;
        int prime = 31;
        int result = 1;
        result = prime * result + (remoteAddr == null ? 0 : remoteAddr.hashCode());
        result = prime * result + remotePort;
        result = prime * result + (userAgent == null ? 0 : userAgent.hashCode());
        this.hash = result = prime * result + (parts == null ? 0 : Key.hashCode(parts));
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Key other = (Key)obj;
        if (this.remotePort != other.remotePort) {
            return false;
        }
        if (this.remoteAddr == null ? other.remoteAddr != null : !this.remoteAddr.equals(other.remoteAddr)) {
            return false;
        }
        if (this.userAgent == null ? other.userAgent != null : !this.userAgent.equals(other.userAgent)) {
            return false;
        }
        return !(this.parts == null ? other.parts != null : !this.parts.equals(other.parts));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("Key [");
        if (this.remotePort > 0) {
            builder.append("remotePort=").append(this.remotePort).append(", ");
        }
        if (this.remoteAddr != null) {
            builder.append("remoteAddr=").append(this.remoteAddr).append(", ");
        }
        if (this.userAgent != null) {
            builder.append("userAgent=").append(this.userAgent).append(", ");
        }
        if (this.parts != null) {
            builder.append("parts=").append(this.parts).append(", ");
        }
        builder.append("hash=").append(this.hash).append("]");
        return builder.toString();
    }

    private static List<String> extractParts(HttpServletRequest servletRequest) {
        List<KeyPartProvider> keyPartProviders = RateLimiter.keyPartProviders();
        if (null == keyPartProviders || keyPartProviders.isEmpty()) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>(keyPartProviders.size());
        for (KeyPartProvider keyPartProvider : keyPartProviders) {
            parts.add(keyPartProvider.getValue(servletRequest));
        }
        return parts;
    }
}

