/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.http;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.helper.BrowserDetector;
import com.openexchange.authentication.Cookie;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.groupware.notify.hostname.internal.HostDataImpl;
import com.openexchange.html.HtmlService;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.osgi.util.ServiceCallWrapper;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.systemname.SystemNameService;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.encoding.Helper;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.AuthCookie;
import com.openexchange.tools.servlet.http.Cookies;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.idn.IDNA;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Tools {
    public static final String COM_OPENEXCHANGE_CHECK_URL_PARAMS = "com.openexchange.check.url.params";
    private static final Logger LOG = LoggerFactory.getLogger(Tools.class);
    private static final DateFormat HEADER_DATEFORMAT;
    private static final String NAME_CACHE_CONTROL = "Cache-Control";
    private static final String NAME_EXPIRES = "Expires";
    private static final String NAME_ETAG = "ETag";
    private static final String EXPIRES_DATE;
    private static final String CACHE_VALUE = "no-store, no-cache, must-revalidate, post-check=0, pre-check=0";
    private static final String PRAGMA_KEY = "Pragma";
    private static final String PRAGMA_VALUE = "no-cache";
    private static final AtomicReference<ConfigurationService> CONFIG_SERVICE_REF;
    private static final long MILLIS_5MIN = 300000L;
    private static final long MILLIS_HOUR = 3600000L;
    private static final long MILLIS_WEEK = 604800000L;
    private static final long MILLIS_YEAR = 31449600000L;
    public static final String HEADER_AGENT = "User-Agent";
    public static final String HEADER_TYPE = "Content-Type";
    public static final String HEADER_REFERER = "Referer";
    public static final String HEADER_LENGTH = "Content-Length";
    public static final String JSESSIONID_COOKIE = "JSESSIONID";
    private static final CookieNameMatcher OX_COOKIE_MATCHER;
    private static final String NAME_ACCEPT_LANGUAGE;
    private static final String MULTIPART = "multipart/";
    private static final Pattern PATTERN_BYTE_RANGES;

    private Tools() {
    }

    public static String toACE(String idnAddress) throws OXException {
        try {
            return IDNA.toACE((String)idnAddress);
        }
        catch (AddressException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
    }

    public static String toIDN(String aceAddress) {
        return IDNA.toIDN((String)aceAddress);
    }

    public static void setETag(String eTag, HttpServletResponse resp) {
        Tools.setETag(eTag, -1L, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setETag(String eTag, long expiry, HttpServletResponse resp) {
        Tools.removeCachingHeader(resp);
        if (null != eTag) {
            resp.setHeader(NAME_ETAG, eTag);
        }
        if (expiry <= 0L) {
            DateFormat dateFormat = HEADER_DATEFORMAT;
            synchronized (dateFormat) {
                resp.setHeader(NAME_EXPIRES, HEADER_DATEFORMAT.format(new Date(System.currentTimeMillis() + 300000L)));
            }
            resp.setHeader(NAME_CACHE_CONTROL, "private, max-age=300");
        } else {
            DateFormat dateFormat = HEADER_DATEFORMAT;
            synchronized (dateFormat) {
                resp.setHeader(NAME_EXPIRES, HEADER_DATEFORMAT.format(new Date(System.currentTimeMillis() + expiry)));
            }
            resp.setHeader(NAME_CACHE_CONTROL, "private, max-age=" + expiry / 1000L);
        }
    }

    public static long getDefaultExpiry() {
        return 300000L;
    }

    public static long getDefaultImageExpiry() {
        return 3600000L;
    }

    public static void setExpires(long expiry, HttpServletResponse resp) {
        Tools.setETag(null, expiry, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultExpiry(HttpServletResponse resp) {
        DateFormat dateFormat = HEADER_DATEFORMAT;
        synchronized (dateFormat) {
            resp.setHeader(NAME_EXPIRES, HEADER_DATEFORMAT.format(new Date(System.currentTimeMillis() + 300000L)));
        }
        resp.setHeader(NAME_CACHE_CONTROL, "private, max-age=300");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultImageExpiry(HttpServletResponse resp) {
        DateFormat dateFormat = HEADER_DATEFORMAT;
        synchronized (dateFormat) {
            resp.setHeader(NAME_EXPIRES, HEADER_DATEFORMAT.format(new Date(System.currentTimeMillis() + 3600000L)));
        }
        resp.setHeader(NAME_CACHE_CONTROL, "private, max-age=3600");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExpiresInOneYear(HttpServletResponse resp) {
        DateFormat dateFormat = HEADER_DATEFORMAT;
        synchronized (dateFormat) {
            resp.setHeader(NAME_EXPIRES, HEADER_DATEFORMAT.format(new Date(System.currentTimeMillis() + 31449600000L)));
        }
        resp.setHeader(NAME_CACHE_CONTROL, "private, max-age=31521018");
    }

    public static void disableCaching(HttpServletResponse resp) {
        resp.setHeader(NAME_EXPIRES, EXPIRES_DATE);
        resp.setHeader(NAME_CACHE_CONTROL, CACHE_VALUE);
        resp.setHeader(PRAGMA_KEY, PRAGMA_VALUE);
    }

    public static void removeCachingHeader(HttpServletResponse resp) {
        resp.setHeader(PRAGMA_KEY, null);
        resp.setHeader(NAME_CACHE_CONTROL, null);
        resp.setHeader(NAME_EXPIRES, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatHeaderDate(Date date) {
        DateFormat dateFormat = HEADER_DATEFORMAT;
        synchronized (dateFormat) {
            return HEADER_DATEFORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseHeaderDate(String str) throws ParseException {
        DateFormat dateFormat = HEADER_DATEFORMAT;
        synchronized (dateFormat) {
            return HEADER_DATEFORMAT.parse(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long optHeaderDate(String str) {
        if (null == str) {
            return -1L;
        }
        DateFormat dateFormat = HEADER_DATEFORMAT;
        synchronized (dateFormat) {
            try {
                return HEADER_DATEFORMAT.parse(str).getTime();
            }
            catch (ParseException e) {
                return -1L;
            }
        }
    }

    public static String logHeaderForError(HttpServletRequest req) {
        StringBuilder message = new StringBuilder();
        String sep = System.getProperty("line.separator");
        message.append("|").append(sep);
        message.append(HEADER_AGENT);
        message.append(": ");
        message.append(req.getHeader(HEADER_AGENT));
        message.append(sep);
        message.append(HEADER_TYPE);
        message.append(": ");
        message.append(req.getHeader(HEADER_TYPE));
        message.append(sep);
        message.append(HEADER_REFERER);
        message.append(": ");
        message.append(req.getHeader(HEADER_REFERER));
        message.append(sep);
        message.append(HEADER_LENGTH);
        message.append(": ");
        message.append(req.getHeader(HEADER_LENGTH));
        return message.toString();
    }

    public static void deleteCookies(HttpServletRequest req, HttpServletResponse resp) {
        Tools.deleteCookies(req, resp, OX_COOKIE_MATCHER);
    }

    public static void deleteCookies(HttpServletRequest req, HttpServletResponse resp, CookieNameMatcher matcher) {
        javax.servlet.http.Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (javax.servlet.http.Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (!matcher.matches(cookieName)) continue;
                javax.servlet.http.Cookie respCookie = new javax.servlet.http.Cookie(cookieName, cookie.getValue());
                respCookie.setPath("/");
                respCookie.setMaxAge(0);
                resp.addCookie(respCookie);
            }
        }
    }

    public static void setHeaderForFileDownload(String userAgent, HttpServletResponse resp, String fileName) throws UnsupportedEncodingException {
        Tools.setHeaderForFileDownload(userAgent, resp, fileName, null);
    }

    public static void setHeaderForFileDownload(String userAgent, HttpServletResponse resp, String fileName, String contentDisposition) throws UnsupportedEncodingException {
        BrowserDetector detector = BrowserDetector.detectorFor(userAgent);
        String cd = contentDisposition;
        if (cd == null) {
            cd = "attachment";
        }
        String filename = null;
        filename = detector.isMSIE() ? Helper.encodeFilenameForIE(fileName, Charsets.UTF_8) : (detector.isSafari5() ? new String(fileName.getBytes(Charsets.UTF_8), Charsets.ISO_8859_1) : Helper.escape(Helper.encodeFilename(fileName, "UTF-8")));
        if (cd.indexOf(59) < 0 && filename != null) {
            cd = new StringBuilder(64).append(cd).append("; filename=\"").append(filename).append('\"').toString();
        }
        resp.setHeader("Content-Disposition", cd);
    }

    public static String getProtocol(HttpServletRequest req) {
        return Tools.considerSecure(req) ? "https://" : "http://";
    }

    public static boolean considerSecure(HttpServletRequest req) {
        ConfigurationService configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (configurationService != null && configurationService.getBoolProperty(ServerConfig.Property.FORCE_HTTPS.getPropertyName(), false) && !Cookies.isLocalLan(req)) {
            return true;
        }
        return req.isSecure();
    }

    public static boolean considerSecure(HttpServletRequest req, boolean force) {
        if (force && !Cookies.isLocalLan(req)) {
            return true;
        }
        return req.isSecure();
    }

    public static String getRoute(String httpSessionId) {
        if (null == httpSessionId) {
            return null;
        }
        int pos = httpSessionId.indexOf(46);
        return pos > 0 ? httpSessionId : httpSessionId + '.' + ServerServiceRegistry.getInstance().getService(SystemNameService.class).getSystemName();
    }

    public static Locale getLocaleByAcceptLanguage(HttpServletRequest request, Locale defaultLocale) {
        if (null == request) {
            return defaultLocale;
        }
        String header = request.getHeader(NAME_ACCEPT_LANGUAGE);
        if (Strings.isEmpty((String)header)) {
            return defaultLocale;
        }
        int pos = header.indexOf(59);
        if (pos > 0) {
            header = header.substring(0, pos);
        }
        Locale l = LocaleTools.getLocale((String)((pos = (header = header.trim()).indexOf(44)) > 0 ? header.substring(0, pos) : header));
        return null == l ? defaultLocale : l;
    }

    public static final boolean isMultipartContent(HttpServletRequest request) {
        if (null == request) {
            return false;
        }
        String contentType = request.getContentType();
        return null != contentType && Strings.asciiLowerCase((String)contentType).startsWith(MULTIPART);
    }

    public static final Map<String, List<String>> copyHeaders(HttpServletRequest req) {
        if (null == req) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            LinkedList<String> values = (LinkedList<String>)headers.get(name);
            if (null == values) {
                values = new LinkedList<String>();
                headers.put(name, values);
            }
            Enumeration valueEnum = req.getHeaders(name);
            while (valueEnum.hasMoreElements()) {
                values.add((String)valueEnum.nextElement());
            }
        }
        return headers;
    }

    public static Cookie[] getCookieFromHeader(HttpServletRequest req) {
        if (null == req) {
            return new Cookie[0];
        }
        javax.servlet.http.Cookie[] cookies = req.getCookies();
        if (null == cookies) {
            return new Cookie[0];
        }
        Cookie[] retval = new Cookie[cookies.length];
        for (int i = 0; i < cookies.length; ++i) {
            retval[i] = Tools.getCookie(cookies[i]);
        }
        return retval;
    }

    private static Cookie getCookie(javax.servlet.http.Cookie cookie) {
        return new AuthCookie(cookie);
    }

    public static HostData createHostData(HttpServletRequest request, int contextId, int userId, boolean isGuest) {
        String host = Tools.determineHostname(request, contextId, userId, isGuest);
        int port = request.getServerPort();
        String dispatcherPrefix = Tools.determineServletPrefix();
        boolean secure = Tools.considerSecure(request);
        HttpSession httpSession = request.getSession(false);
        String httpSessionID = null != httpSession ? httpSession.getId() : null;
        String route = Tools.extractRoute(httpSessionID);
        return new HostDataImpl(secure, host, port, httpSessionID, route, dispatcherPrefix);
    }

    public static String extractRoute(String httpSessionID) {
        int index;
        if (null != httpSessionID && 0 < (index = httpSessionID.indexOf(46)) && index < httpSessionID.length() - 1) {
            return httpSessionID.substring(index + 1);
        }
        return Tools.determineBackendRoute();
    }

    public static void sendErrorResponse(HttpServletResponse httpResponse, int statusCode, String body) throws IOException {
        Tools.sendErrorResponse(httpResponse, statusCode, Collections.emptyMap(), body);
    }

    public static void sendErrorResponse(HttpServletResponse httpResponse, int statusCode, Map<String, String> additionalHeaders, String body) throws IOException {
        for (Map.Entry<String, String> header : additionalHeaders.entrySet()) {
            httpResponse.setHeader(header.getKey(), header.getValue());
        }
        httpResponse.setContentType("application/json;charset=UTF-8");
        httpResponse.setStatus(statusCode);
        PrintWriter writer = httpResponse.getWriter();
        writer.write(body);
        writer.flush();
    }

    public static void sendEmptyErrorResponse(HttpServletResponse httpResponse, int statusCode) throws IOException {
        Tools.sendEmptyErrorResponse(httpResponse, statusCode, Collections.emptyMap());
    }

    public static void sendEmptyErrorResponse(HttpServletResponse httpResponse, int statusCode, Map<String, String> additionalHeaders) throws IOException {
        httpResponse.setContentType(null);
        for (Map.Entry<String, String> header : additionalHeaders.entrySet()) {
            httpResponse.setHeader(header.getKey(), header.getValue());
        }
        httpResponse.sendError(statusCode);
    }

    public static void sendErrorPage(HttpServletResponse httpResponse, int statusCode, String desc) throws IOException {
        httpResponse.setContentType("text/html; charset=UTF-8");
        httpResponse.setHeader("Content-Disposition", "inline");
        httpResponse.setStatus(statusCode);
        PrintWriter writer = httpResponse.getWriter();
        writer.write(Tools.getErrorPage(statusCode, null, desc));
        writer.flush();
    }

    public static String getErrorPage(int statusCode, String msg, String desc) {
        String desc0;
        String msg0 = null == msg ? HttpStatus.getStatusText((int)statusCode) : msg;
        StringBuilder sb = new StringBuilder(512);
        String lineSep = System.getProperty("line.separator");
        sb.append("<!DOCTYPE html>").append(lineSep);
        sb.append("<html><head>").append(lineSep);
        sb.append("<title>").append(statusCode);
        if (null != msg0) {
            sb.append(' ').append(Tools.filter(msg0));
        }
        sb.append("</title>").append(lineSep);
        sb.append("</head><body>").append(lineSep);
        sb.append("<h1>");
        if (null == msg0) {
            sb.append(statusCode);
        } else {
            sb.append(Tools.filter(msg0));
        }
        sb.append("</h1>").append(lineSep);
        String string = desc0 = null == desc ? msg0 : desc;
        if (null != desc0) {
            sb.append("<p>").append(Tools.filter(desc0)).append("</p>").append(lineSep);
        }
        sb.append("</body></html>").append(lineSep);
        return sb.toString();
    }

    public static String getEmptyPage() {
        StringBuilder sb = new StringBuilder(128);
        String lineSep = System.getProperty("line.separator");
        sb.append("<!DOCTYPE html>").append(lineSep);
        sb.append("<html><head>").append(lineSep);
        sb.append("<title>A blank HTML page</title>").append(lineSep);
        sb.append("<meta charset=\"utf-8\" />").append(lineSep);
        sb.append("</head><body>").append(lineSep);
        sb.append("</body></html>").append(lineSep);
        return sb.toString();
    }

    public static String filter(String message) {
        HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
        return null == htmlService ? Tools.filter0(message) : htmlService.encodeForHTML(message);
    }

    private static String filter0(String message) {
        if (message == null) {
            return null;
        }
        int length = message.length();
        if (length <= 0) {
            return message;
        }
        int i = 0;
        int k = length;
        block12: while (k-- > 0) {
            char c = message.charAt(i);
            switch (c) {
                case '<': {
                    k = 0;
                    continue block12;
                }
                case '>': {
                    k = 0;
                    continue block12;
                }
                case '&': {
                    k = 0;
                    continue block12;
                }
                case '\"': {
                    k = 0;
                    continue block12;
                }
            }
            ++i;
        }
        if (i >= length) {
            return message;
        }
        StringBuilder result = new StringBuilder(length + 50);
        if (i > 0) {
            result.append(message, 0, i);
        }
        int k2 = length - i;
        block13: while (k2-- > 0) {
            char c = message.charAt(i++);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block13;
                }
                case '>': {
                    result.append("&gt;");
                    continue block13;
                }
                case '&': {
                    result.append("&amp;");
                    continue block13;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block13;
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    public static boolean hasRangeHeader(HttpServletRequest req) {
        if (null == req) {
            return false;
        }
        return Tools.isByteRangeHeader(req.getHeader("Range"));
    }

    public static boolean isByteRangeHeader(String range) {
        return null != range && PATTERN_BYTE_RANGES.matcher(range).matches();
    }

    private static String determineServletPrefix() {
        try {
            return (String)ServiceCallWrapper.tryServiceCall(Tools.class, DispatcherPrefixService.class, (ServiceCallWrapper.ServiceUser)new ServiceCallWrapper.ServiceUser<DispatcherPrefixService, String>(){

                public String call(DispatcherPrefixService service) throws Exception {
                    return service.getPrefix();
                }
            }, (Object)"/ajax/");
        }
        catch (ServiceCallWrapper.ServiceException e) {
            return "/ajax/";
        }
    }

    private static String determineBackendRoute() {
        try {
            return (String)ServiceCallWrapper.tryServiceCall(Tools.class, SystemNameService.class, (ServiceCallWrapper.ServiceUser)new ServiceCallWrapper.ServiceUser<SystemNameService, String>(){

                public String call(SystemNameService service) throws Exception {
                    return service.getSystemName();
                }
            }, (Object)"OX1");
        }
        catch (ServiceCallWrapper.ServiceException e) {
            return "OX1";
        }
    }

    private static String determineHostname(HttpServletRequest servletRequest, final int contextId, final int userId, final boolean isGuest) {
        String hostname = null;
        try {
            hostname = (String)ServiceCallWrapper.tryServiceCall(Tools.class, HostnameService.class, (ServiceCallWrapper.ServiceUser)new ServiceCallWrapper.ServiceUser<HostnameService, String>(){

                public String call(HostnameService service) throws Exception {
                    if (isGuest) {
                        return service.getGuestHostname(userId, contextId);
                    }
                    return service.getHostname(userId, contextId);
                }
            }, null);
        }
        catch (ServiceCallWrapper.ServiceException e) {
            // empty catch block
        }
        if (hostname == null) {
            hostname = servletRequest.getServerName();
        }
        return hostname;
    }

    public static void checkNonExistence(HttpServletRequest req, String ... parameters) throws OXException {
        ConfigurationService configService = CONFIG_SERVICE_REF.get();
        if (configService == null || req == null || parameters == null) {
            LOG.debug("One of the provided parameters is null. Return without checking parameters.");
            return;
        }
        if (!configService.getBoolProperty(COM_OPENEXCHANGE_CHECK_URL_PARAMS, true)) {
            LOG.debug("com.openexchange.check.url.params configured to false. return without checking parameters.");
            return;
        }
        String queryString = req.getQueryString();
        if (queryString == null || queryString.isEmpty()) {
            return;
        }
        Map<String, List<String>> parameterMap = null;
        try {
            parameterMap = Tools.splitQuery(queryString);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Unable to analyze query string. Will not check for undesired URI params.", (Throwable)e);
            return;
        }
        if (parameterMap == null) {
            return;
        }
        ArrayList<String> notAllowed = new ArrayList<String>();
        for (String parameter : parameters) {
            if (!parameterMap.containsKey(parameter)) continue;
            notAllowed.add(parameter);
        }
        if (!notAllowed.isEmpty()) {
            throw AjaxExceptionCodes.NOT_ALLOWED_URI_PARAM.create(Strings.concat((String)", ", (Object[])new Object[]{notAllowed}));
        }
    }

    private static Map<String, List<String>> splitQuery(String queryString) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, List<String>> queryPairs = new LinkedHashMap<String, List<String>>();
        for (String pair : pairs = queryString.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!queryPairs.containsKey(key)) {
                queryPairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            ((List)queryPairs.get(key)).add(value);
        }
        return queryPairs;
    }

    public static void setConfigurationService(ConfigurationService configurationService) {
        CONFIG_SERVICE_REF.set(configurationService);
    }

    static {
        CONFIG_SERVICE_REF = new AtomicReference();
        HEADER_DATEFORMAT = new SimpleDateFormat("EEE',' dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        HEADER_DATEFORMAT.setTimeZone(TimeZoneUtils.getTimeZone("GMT"));
        EXPIRES_DATE = HEADER_DATEFORMAT.format(new Date(799761600000L));
        OX_COOKIE_MATCHER = new CookieNameMatcher(){

            @Override
            public boolean matches(String cookieName) {
                return null != cookieName && (cookieName.startsWith(LoginServlet.SESSION_PREFIX) || Tools.JSESSIONID_COOKIE.equals(cookieName));
            }
        };
        NAME_ACCEPT_LANGUAGE = "Accept-Language".intern();
        PATTERN_BYTE_RANGES = Pattern.compile("^bytes=\\d*-\\d*(,\\d*-\\d*)*$");
    }

    public static interface CookieNameMatcher {
        public boolean matches(String var1);
    }
}

