/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.http;

import com.google.common.net.InternetDomainName;
import com.openexchange.ajax.LoginServlet;
import com.openexchange.config.ConfigurationService;
import com.openexchange.java.IPAddressUtil;
import com.openexchange.java.Strings;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class Cookies {
    private static final Set<String> LOCALS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("localhost", "127.0.0.1", "::1")));
    private static volatile Boolean domainEnabled;
    private static volatile Boolean prefixWithDot;
    private static volatile String configuredDomain;

    private Cookies() {
    }

    public static boolean isLocalLan(HttpServletRequest request) {
        return Cookies.isLocalLan(request.getServerName());
    }

    public static boolean isLocalLan(String serverName) {
        if (Strings.isEmpty((String)serverName)) {
            return false;
        }
        return LOCALS.contains(serverName.toLowerCase(Locale.US));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean domainEnabled() {
        Boolean tmp = domainEnabled;
        if (null != tmp) return tmp;
        Class<LoginServlet> clazz = LoginServlet.class;
        synchronized (LoginServlet.class) {
            tmp = domainEnabled;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            domainEnabled = tmp = Boolean.valueOf(null != service && service.getBoolProperty("com.openexchange.cookie.domain.enabled", false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean prefixWithDot() {
        Boolean tmp = prefixWithDot;
        if (null != tmp) return tmp;
        Class<LoginServlet> clazz = LoginServlet.class;
        synchronized (LoginServlet.class) {
            tmp = prefixWithDot;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            prefixWithDot = tmp = Boolean.valueOf(null == service || service.getBoolProperty("com.openexchange.cookie.domain.prefixWithDot", true));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String configuredDomain() {
        String tmp = configuredDomain;
        if (null == tmp) {
            Class<LoginServlet> clazz = LoginServlet.class;
            // MONITORENTER : com.openexchange.ajax.LoginServlet.class
            tmp = configuredDomain;
            if (null == tmp) {
                ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
                configuredDomain = tmp = null == service ? "null" : service.getProperty("com.openexchange.cookie.domain", "null");
            }
            // MONITOREXIT : clazz
        }
        if ("null".equalsIgnoreCase(tmp)) {
            return null;
        }
        String string = tmp;
        return string;
    }

    public static String getDomainValue(String serverName) {
        if (!Cookies.domainEnabled()) {
            return null;
        }
        String configuredDomain = Cookies.configuredDomain();
        if (null != configuredDomain) {
            return configuredDomain;
        }
        return Cookies.getDomainValue(serverName, Cookies.prefixWithDot(), null, true);
    }

    public static String getDomainValue(String serverName, boolean prefixWithDot, String configuredDomain, boolean domainEnabled) {
        if (!domainEnabled) {
            return null;
        }
        if (null != configuredDomain) {
            return configuredDomain;
        }
        if (null == serverName) {
            return null;
        }
        if (prefixWithDot) {
            if (serverName.startsWith("www.")) {
                return serverName.substring(3);
            }
            if ("localhost".equalsIgnoreCase(serverName)) {
                return null;
            }
            if (null == IPAddressUtil.textToNumericFormatV4((String)serverName) && null == IPAddressUtil.textToNumericFormatV6((String)serverName)) {
                int fpos = serverName.indexOf(46);
                if (fpos < 0) {
                    return null;
                }
                int pos = serverName.indexOf(46, fpos + 1);
                if (pos < 0) {
                    return null;
                }
                String domain = serverName.substring(fpos);
                InternetDomainName tmp = InternetDomainName.from((String)domain);
                if (tmp.isPublicSuffix()) {
                    return null;
                }
                return domain;
            }
        } else if (!"localhost".equalsIgnoreCase(serverName) && null == IPAddressUtil.textToNumericFormatV4((String)serverName) && null == IPAddressUtil.textToNumericFormatV6((String)serverName)) {
            return serverName.toLowerCase(Locale.US).startsWith("www.") ? serverName.substring(4) : serverName;
        }
        return null;
    }

    public static String extractDomainValue(String id) {
        int end;
        if (null == id) {
            return null;
        }
        int start = id.indexOf(45);
        if (start > 0 && (end = id.lastIndexOf(46)) > start) {
            return Cookies.urlDecode(id.substring(start + 1, end));
        }
        return null;
    }

    private static String urlDecode(String text) {
        try {
            return URLDecoder.decode(text, "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return text;
        }
    }

    public static String prettyPrint(Cookie[] cookies) {
        if (null == cookies) {
            return "";
        }
        StringBuilder sb = new StringBuilder(cookies.length << 4);
        String sep = System.getProperty("line.separator");
        for (int i = 0; i < cookies.length; ++i) {
            boolean secure;
            String domain;
            String path;
            Cookie cookie = cookies[i];
            sb.append(i + 1).append(": ").append(cookie.getName());
            sb.append('=').append(cookie.getValue());
            sb.append("; version=").append(cookie.getVersion());
            int maxAge = cookie.getMaxAge();
            if (maxAge >= 0) {
                sb.append("; max-age=").append(maxAge);
            }
            if (null != (path = cookie.getPath())) {
                sb.append("; path=").append(path);
            }
            if (null != (domain = cookie.getDomain())) {
                sb.append("; domain=").append(path);
            }
            if (secure = cookie.getSecure()) {
                sb.append("; secure");
            }
            sb.append(sep);
        }
        return sb.toString();
    }

    public static Map<String, Cookie> cookieMapFor(HttpServletRequest req) {
        if (null == req) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Cookie> m = (LinkedHashMap<String, Cookie>)req.getAttribute("__cookie.map");
        if (null != m) {
            return m;
        }
        Cookie[] cookies = req.getCookies();
        if (null == cookies) {
            return Collections.emptyMap();
        }
        int length = cookies.length;
        m = new LinkedHashMap<String, Cookie>(length);
        for (Cookie cookie : cookies) {
            m.put(cookie.getName(), cookie);
        }
        req.setAttribute("__cookie.map", m);
        return m;
    }
}

