/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.memory;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.java.RunOrGetFutureTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConditionTreeMapManagement {
    static final Logger LOG = LoggerFactory.getLogger(ConditionTreeMapManagement.class);
    private static volatile ConditionTreeMapManagement instance;
    private static final int TIME2LIVE = 360000;
    protected final LoadingCache<Integer, FutureTask<ConditionTreeMap>> context2maps;
    private final boolean enabled;
    private volatile ScheduledTimerTask timerTask;

    public static void startInstance() {
        ConditionTreeMapManagement.stopInstance();
        instance = new ConditionTreeMapManagement();
        instance.start();
    }

    public static void stopInstance() {
        ConditionTreeMapManagement mm = instance;
        if (null == mm) {
            return;
        }
        mm.stop();
        instance = null;
    }

    public static ConditionTreeMapManagement getInstance() {
        return instance;
    }

    public static void dropFor(int contextId) {
        ConditionTreeMapManagement mm = instance;
        if (null != mm) {
            mm.context2maps.invalidate((Object)contextId);
        }
    }

    private ConditionTreeMapManagement() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().concurrencyLevel(4).initialCapacity(8192).expireAfterAccess(360000L, TimeUnit.MILLISECONDS);
        this.context2maps = cacheBuilder.build((CacheLoader)new CacheLoader<Integer, FutureTask<ConditionTreeMap>>(){

            public FutureTask<ConditionTreeMap> load(Integer contextId) throws Exception {
                return RunOrGetFutureTask.newInstance((Callable)new InitTreeMapCallable(contextId, LOG));
            }
        });
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        this.enabled = null == service || service.getBoolProperty("com.openexchange.oxfolder.memory.enabled", true);
    }

    private void start() {
        ShrinkerRunnable task = new ShrinkerRunnable();
        int delay = 20000;
        this.timerTask = ServerServiceRegistry.getInstance().getService(TimerService.class).scheduleWithFixedDelay((Runnable)task, (long)delay, (long)delay);
    }

    private void stop() {
        ScheduledTimerTask timerTask = this.timerTask;
        if (null != timerTask) {
            timerTask.cancel();
            this.timerTask = null;
        }
        this.context2maps.invalidateAll();
    }

    public ConditionTreeMap getMapFor(int contextId) throws OXException {
        if (!this.enabled) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create("Memory tree map disabled as per configuration.");
        }
        try {
            return this.getFrom((Future)this.context2maps.get((Object)contextId));
        }
        catch (ExecutionException e) {
            throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)e, OXException.class));
        }
    }

    public ConditionTreeMap optMapFor(int contextId) throws OXException {
        return this.optMapFor(contextId, true);
    }

    public ConditionTreeMap optMapFor(int contextId, boolean triggerLoad) throws OXException {
        if (!this.enabled) {
            return null;
        }
        Future f = (Future)this.context2maps.getIfPresent((Object)contextId);
        if (null != f) {
            return this.timedFrom(f, 1000L);
        }
        if (triggerLoad) {
            ThreadPools.getThreadPool().submit(ThreadPools.trackableTask((Runnable)new LoadTreeMapRunnable(contextId, LOG)));
        }
        return null;
    }

    protected ConditionTreeMap getFrom(Future<ConditionTreeMap> f) throws OXException {
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, e.getMessage());
        }
        catch (ExecutionException e) {
            throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)e, OXException.class));
        }
    }

    protected ConditionTreeMap timedFrom(Future<ConditionTreeMap> f, long timeoutMillis) throws OXException {
        try {
            return f.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, e.getMessage());
        }
        catch (ExecutionException e) {
            throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)e, OXException.class));
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    protected void shrink() {
        this.context2maps.cleanUp();
        long maxStamp = System.currentTimeMillis() - 360000L;
        for (Future future : this.context2maps.asMap().values()) {
            if (null == future) continue;
            try {
                ConditionTreeMap map = this.getFrom(future);
                map.trim(maxStamp);
            }
            catch (Exception e) {}
        }
    }

    private static final class InitTreeMapCallable
    implements Callable<ConditionTreeMap> {
        private final int contextId;
        private final Logger logger;

        InitTreeMapCallable(int contextId, Logger logger) {
            this.contextId = contextId;
            this.logger = logger;
        }

        @Override
        public ConditionTreeMap call() {
            try {
                ConditionTreeMap newMap = new ConditionTreeMap(this.contextId, 360000);
                newMap.init();
                return newMap;
            }
            catch (OXException e) {
                this.logger.warn("", (Throwable)e);
                return null;
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
                return null;
            }
        }
    }

    private final class LoadTreeMapRunnable
    implements Runnable {
        private final int contextId;
        private final Logger logger;

        LoadTreeMapRunnable(int contextId, Logger logger) {
            this.contextId = contextId;
            this.logger = logger;
        }

        @Override
        public void run() {
            try {
                FutureTask ft = (FutureTask)ConditionTreeMapManagement.this.context2maps.get((Object)this.contextId);
                ft.run();
            }
            catch (Exception e) {
                this.logger.error("", e.getCause());
            }
        }
    }

    private final class ShrinkerRunnable
    implements Runnable {
        protected ShrinkerRunnable() {
        }

        @Override
        public void run() {
            ConditionTreeMapManagement.this.shrink();
        }
    }
}

