/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.Streams;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.io.Closeable;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONException;

public final class OXFolderLoader {
    private static final String TABLE_OT = "oxfolder_tree";
    private static final String TABLE_OP = "oxfolder_permissions";
    private static final Pattern PAT_RPL_TABLE = Pattern.compile("#TABLE#");
    private static final String SQL_LOAD_F = "SELECT parent, fname, module, type, creating_date, created_from, changing_date, changed_from, permission_flag, subfolder_flag, default_flag, meta FROM #TABLE# WHERE cid = ? AND fuid = ?";
    private static final String SQL_LOAD_P = "SELECT permission_id, fp, orp, owp, odp, admin_flag, group_flag, system FROM #TABLE# WHERE cid = ? AND fuid = ?";
    private static final String SQL_SEL2 = "SELECT fuid, fname FROM #TABLE# WHERE cid = ? AND parent = ? ORDER BY default_flag DESC, fname";
    private static final String SQL_SEL = "SELECT fuid FROM #TABLE# WHERE cid = ? AND parent = ? ORDER BY default_flag DESC, fname";

    private OXFolderLoader() {
    }

    public static FolderObject loadFolderObjectFromDB(int folderId, Context ctx) throws OXException {
        return OXFolderLoader.loadFolderObjectFromDB(folderId, ctx, null, true, false);
    }

    public static FolderObject loadFolderObjectFromDB(int folderId, Context ctx, Connection readCon) throws OXException {
        return OXFolderLoader.loadFolderObjectFromDB(folderId, ctx, readCon, true, false);
    }

    public static FolderObject loadFolderObjectFromDB(int folderId, Context ctx, Connection readConArg, boolean loadPermissions, boolean loadSubfolderList) throws OXException {
        return OXFolderLoader.loadFolderObjectFromDB(folderId, ctx, readConArg, loadPermissions, loadSubfolderList, TABLE_OT, TABLE_OP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FolderObject loadFolderObjectFromDB(int folderId, Context ctx, Connection readConArg, boolean loadPermissions, boolean loadSubfolderList, String table, String permTable) throws OXException {
        FolderObject folderObject;
        Connection readCon = readConArg;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(PAT_RPL_TABLE.matcher(SQL_LOAD_F).replaceFirst(table));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(folderId, ctx.getContextId());
            }
            FolderObject folderObj = new FolderObject(rs.getString(2), folderId, rs.getInt(3), rs.getInt(4), rs.getInt(6));
            folderObj.setParentFolderID(rs.getInt(1));
            folderObj.setCreatedBy(OXFolderLoader.parseStringValue(rs.getString(6), ctx));
            folderObj.setCreationDate(new Date(rs.getLong(5)));
            folderObj.setSubfolderFlag(rs.getInt(10) > 0);
            folderObj.setLastModified(new Date(rs.getLong(7)));
            folderObj.setModifiedBy(OXFolderLoader.parseStringValue(rs.getString(8), ctx));
            folderObj.setPermissionFlag(rs.getInt(9));
            int defaultFolder = rs.getInt(11);
            if (rs.wasNull()) {
                folderObj.setDefaultFolder(false);
            } else {
                folderObj.setDefaultFolder(defaultFolder > 0);
            }
            InputStream jsonBlobStream = rs.getBinaryStream(12);
            if (!rs.wasNull() && null != jsonBlobStream) {
                try {
                    folderObj.setMeta(OXFolderUtility.deserializeMeta(jsonBlobStream));
                }
                finally {
                    Streams.close((Closeable)jsonBlobStream);
                }
            }
            if (loadSubfolderList) {
                ArrayList<Integer> subfolderList = OXFolderLoader.getSubfolderIds(folderId, ctx, readCon, table);
                folderObj.setSubfolderIds(subfolderList);
            }
            if (loadPermissions) {
                folderObj.setPermissionsAsArray(OXFolderLoader.getFolderPermissions(folderId, ctx, readCon, permTable));
            }
            folderObject = folderObj;
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            try {
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
                throw throwable;
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.FOLDER_COULD_NOT_BE_LOADED.create(e, Integer.toString(folderId), Integer.toString(ctx.getContextId()));
            }
            catch (JSONException e) {
                throw OXFolderExceptionCode.FOLDER_COULD_NOT_BE_LOADED.create(e, Integer.toString(folderId), Integer.toString(ctx.getContextId()));
            }
        }
        return folderObject;
    }

    public static OCLPermission[] getFolderPermissions(int folderId, Context ctx, Connection readConArg) throws SQLException, OXException {
        return OXFolderLoader.getFolderPermissions(folderId, ctx, readConArg, TABLE_OP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OCLPermission[] getFolderPermissions(int folderId, Context ctx, Connection readConArg, String table) throws SQLException, OXException {
        OCLPermission[] oCLPermissionArray;
        Connection readCon = readConArg;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(PAT_RPL_TABLE.matcher(SQL_LOAD_P).replaceFirst(table));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = stmt.executeQuery();
            ArrayList<OCLPermission> permList = new ArrayList<OCLPermission>();
            while (rs.next()) {
                OCLPermission p = new OCLPermission();
                p.setEntity(rs.getInt(1));
                p.setAllPermission(rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5));
                p.setFolderAdmin(rs.getInt(6) > 0);
                p.setGroupPermission(rs.getInt(7) > 0);
                p.setSystem(rs.getInt(8));
                permList.add(p);
            }
            stmt.close();
            rs = null;
            stmt = null;
            oCLPermissionArray = permList.toArray(new OCLPermission[permList.size()]);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            if (closeCon) {
                DBPool.closeReaderSilent(ctx, readCon);
            }
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (closeCon) {
            DBPool.closeReaderSilent(ctx, readCon);
        }
        return oCLPermissionArray;
    }

    public static List<IdAndName> getSubfolderIdAndNames(int folderId, Context ctx, Connection readConArg) throws SQLException, OXException {
        return OXFolderLoader.getSubfolderIdAndNames(folderId, ctx, readConArg, TABLE_OT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IdAndName> getSubfolderIdAndNames(int folderId, Context ctx, Connection readConArg, String table) throws SQLException, OXException {
        ArrayList<IdAndName> arrayList;
        Connection readCon = readConArg;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(SQL_SEL2.replaceFirst("#TABLE#", table));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = stmt.executeQuery();
            ArrayList<IdAndName> retval = new ArrayList<IdAndName>();
            while (rs.next()) {
                retval.add(new IdAndName(rs.getInt(1), rs.getString(2)));
            }
            arrayList = retval;
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return arrayList;
    }

    public static ArrayList<Integer> getSubfolderIds(int folderId, Context ctx, Connection readConArg) throws SQLException, OXException {
        return OXFolderLoader.getSubfolderIds(folderId, ctx, readConArg, TABLE_OT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Integer> getSubfolderIds(int folderId, Context ctx, Connection readConArg, String table) throws SQLException, OXException {
        ArrayList<Integer> arrayList;
        Connection readCon = readConArg;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(SQL_SEL.replaceFirst("#TABLE#", table));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = stmt.executeQuery();
            ArrayList<Integer> retval = new ArrayList<Integer>();
            while (rs.next()) {
                retval.add(rs.getInt(1));
            }
            arrayList = retval;
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return arrayList;
    }

    public static TIntList getSubfolderInts(int folderId, Context ctx, Connection readConArg) throws SQLException, OXException {
        return OXFolderLoader.getSubfolderInts(folderId, ctx, readConArg, TABLE_OT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TIntList getSubfolderInts(int folderId, Context ctx, Connection readConArg, String table) throws SQLException, OXException {
        TIntArrayList tIntArrayList;
        Connection readCon = readConArg;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(SQL_SEL.replaceFirst("#TABLE#", table));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = stmt.executeQuery();
            TIntArrayList retval = new TIntArrayList();
            while (rs.next()) {
                retval.add(rs.getInt(1));
            }
            tIntArrayList = retval;
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return tIntArrayList;
    }

    private static final int parseStringValue(String str, Context ctx) {
        if (null == str) {
            return -1;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            if (str.equalsIgnoreCase("system")) {
                return ctx.getMailadmin();
            }
            return -1;
        }
    }

    public static final class IdAndName {
        private final int fuid;
        private final String fname;
        private final int hash;

        IdAndName(int fuid, String fname) {
            this.fuid = fuid;
            this.fname = fname;
            int prime = 31;
            int result = 1;
            result = 31 * result + (fname == null ? 0 : fname.hashCode());
            this.hash = result = 31 * result + fuid;
        }

        public int getFolderId() {
            return this.fuid;
        }

        public String getName() {
            return this.fname;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IdAndName)) {
                return false;
            }
            IdAndName other = (IdAndName)obj;
            if (this.fname == null ? other.fname != null : !this.fname.equals(other.fname)) {
                return false;
            }
            return this.fuid == other.fuid;
        }
    }
}

