/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static void closeStuff(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    public static void closeStreamStuff(InputStream input) {
        IOUtils.closeStuff(input);
    }

    public static void closeReaderStuff(Reader reader) {
        IOUtils.closeStuff(reader);
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int length = -1;
        while ((length = in.read(buffer)) > 0) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }
}

