/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.transformations;

import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.imagetransformation.ImageTransformationSignaler;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.images.scheduler.Scheduler;
import com.openexchange.tools.images.transformations.ImageTransformationsImpl;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ImageTransformationsTask
extends ImageTransformationsImpl {
    private static final ThreadPools.ExpectedExceptionFactory<IOException> EXCEPTION_FACTORY = new ThreadPools.ExpectedExceptionFactory<IOException>(){

        public Class<IOException> getType() {
            return IOException.class;
        }

        public IOException newUnexpectedError(Throwable t) {
            if (t instanceof TimeoutException) {
                return new IOException("Image transformation timed out", t);
            }
            String message = t.getMessage();
            return new IOException(null == message ? "Image transformation failed" : message, t);
        }
    };

    public ImageTransformationsTask(BufferedImage sourceImage, Object optSource) {
        super(sourceImage, optSource);
    }

    public ImageTransformationsTask(InputStream sourceImageStream, Object optSource) {
        super(sourceImageStream, optSource);
    }

    public ImageTransformationsTask(IFileHolder imageFile, Object optSource) {
        super(imageFile, optSource);
    }

    @Override
    protected BufferedImage getImage(String formatName, ImageTransformationSignaler signaler) throws IOException {
        try {
            int waitTimeoutSeconds = ImageTransformationsTask.waitTimeoutSeconds();
            if (waitTimeoutSeconds <= 0) {
                return this.getImageWithoutTimeout(formatName, signaler);
            }
            return this.getImageWithTimeout(formatName, signaler, waitTimeoutSeconds);
        }
        catch (OXException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(null == cause ? e : cause);
        }
    }

    private BufferedImage getImageWithoutTimeout(String formatName, ImageTransformationSignaler signaler) throws OXException, IOException {
        FutureTask<BufferedImage> ft = new FutureTask<BufferedImage>(new GetImageCallable(formatName, null, signaler));
        boolean success = Scheduler.getInstance().execute(this.optSource, ft);
        if (!success) {
            throw new IOException("Image transformation rejected");
        }
        return (BufferedImage)ThreadPools.getFrom(ft, EXCEPTION_FACTORY);
    }

    private BufferedImage getImageWithTimeout(String formatName, ImageTransformationSignaler signaler, int waitTimeoutSeconds) throws OXException, IOException, InterruptedIOException {
        CountDownLatch latch = new CountDownLatch(1);
        FutureTask<BufferedImage> ft = new FutureTask<BufferedImage>(new GetImageCallable(formatName, latch, signaler));
        boolean success = Scheduler.getInstance().execute(this.optSource, ft);
        if (!success) {
            throw new IOException("Image transformation rejected");
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            InterruptedIOException ioe = new InterruptedIOException("Awaiting image transformation interrupted");
            ioe.initCause(e);
            throw ioe;
        }
        return (BufferedImage)ThreadPools.getFrom(ft, (long)waitTimeoutSeconds, (TimeUnit)TimeUnit.SECONDS, EXCEPTION_FACTORY);
    }

    protected BufferedImage doGetImage(String formatName, ImageTransformationSignaler signaler) throws IOException {
        return super.getImage(formatName, signaler);
    }

    private static final class LatchBackedSignaler
    implements ImageTransformationSignaler {
        private final ImageTransformationSignaler delegate;
        private final CountDownLatch optLatch;

        LatchBackedSignaler(CountDownLatch optLatch, ImageTransformationSignaler delegate) {
            this.optLatch = optLatch;
            this.delegate = delegate;
        }

        public void onImageRead() {
            CountDownLatch latch;
            ImageTransformationSignaler delegate = this.delegate;
            if (null != delegate) {
                try {
                    delegate.onImageRead();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (null != (latch = this.optLatch)) {
                latch.countDown();
            }
        }
    }

    private final class GetImageCallable
    implements Callable<BufferedImage> {
        private final String formatName;
        private final LatchBackedSignaler signaler;
        private final CountDownLatch optLatch;

        GetImageCallable(String formatName, CountDownLatch optLatch, ImageTransformationSignaler delegate) {
            this.formatName = formatName;
            this.optLatch = optLatch;
            this.signaler = new LatchBackedSignaler(optLatch, delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferedImage call() throws Exception {
            CountDownLatch latch = this.optLatch;
            if (null == latch) {
                return ImageTransformationsTask.this.doGetImage(this.formatName, this.signaler);
            }
            try {
                BufferedImage bufferedImage = ImageTransformationsTask.this.doGetImage(this.formatName, this.signaler);
                return bufferedImage;
            }
            finally {
                latch.countDown();
            }
        }
    }
}

