/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.transformations;

import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.psd.PsdMetadataReader;
import com.drew.metadata.Metadata;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.exception.OXException;
import com.openexchange.imagetransformation.BasicTransformedImage;
import com.openexchange.imagetransformation.Constants;
import com.openexchange.imagetransformation.ImageInformation;
import com.openexchange.imagetransformation.ImageTransformationDeniedIOException;
import com.openexchange.imagetransformation.ImageTransformationReloadable;
import com.openexchange.imagetransformation.ImageTransformationSignaler;
import com.openexchange.imagetransformation.ImageTransformations;
import com.openexchange.imagetransformation.ScaleType;
import com.openexchange.imagetransformation.TransformationContext;
import com.openexchange.imagetransformation.TransformedImage;
import com.openexchange.java.Streams;
import com.openexchange.tools.images.DefaultTransformedImageCreator;
import com.openexchange.tools.images.ImageTransformationUtility;
import com.openexchange.tools.images.osgi.Services;
import com.openexchange.tools.images.transformations.CropTransformation;
import com.openexchange.tools.images.transformations.ImageTransformation;
import com.openexchange.tools.images.transformations.ImageTransformationsTask;
import com.openexchange.tools.images.transformations.RotateTransformation;
import com.openexchange.tools.images.transformations.ScaleTransformation;
import com.openexchange.tools.stream.CountingInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTransformationsImpl
implements ImageTransformations {
    private static Logger LOG = LoggerFactory.getLogger(ImageTransformationsImpl.class);
    private static volatile Integer waitTimeoutSeconds;
    private static volatile Long maxSize;
    private static volatile Long maxResolution;
    private static final CountingInputStream.IOExceptionCreator IMAGE_SIZE_EXCEEDED_EXCEPTION_CREATOR;
    private static final int JPEG_FILE_MAGIC_NUMBER = 65496;
    private static final int MOTOROLA_TIFF_MAGIC_NUMBER = 19789;
    private static final int INTEL_TIFF_MAGIC_NUMBER = 18761;
    private static final int PSD_MAGIC_NUMBER = 14402;
    private final TransformationContext transformationContext;
    private final InputStream sourceImageStream;
    private final IFileHolder sourceImageFile;
    private final List<ImageTransformation> transformations;
    private BufferedImage sourceImage;
    private Metadata metadata;
    private boolean compress;
    protected final Object optSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int waitTimeoutSeconds() {
        Integer tmp = waitTimeoutSeconds;
        if (null != tmp) return tmp;
        Class<ImageTransformationsTask> clazz = ImageTransformationsTask.class;
        synchronized (ImageTransformationsTask.class) {
            tmp = waitTimeoutSeconds;
            if (null != tmp) return tmp;
            int defaultValue = 10;
            ConfigurationService configService = Services.getService(ConfigurationService.class);
            if (null == configService) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultValue;
            }
            waitTimeoutSeconds = tmp = Integer.valueOf(configService.getIntProperty("com.openexchange.tools.images.transformations.waitTimeoutSeconds", defaultValue));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static long maxSize() {
        Long tmp = maxSize;
        if (null != tmp) return tmp;
        Class<ImageTransformationsTask> clazz = ImageTransformationsTask.class;
        synchronized (ImageTransformationsTask.class) {
            tmp = maxSize;
            if (null != tmp) return tmp;
            int defaultValue = 0x500000;
            ConfigurationService configService = Services.getService(ConfigurationService.class);
            if (null == configService) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultValue;
            }
            maxSize = tmp = Long.valueOf(configService.getIntProperty("com.openexchange.tools.images.transformations.maxSize", defaultValue));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static long maxResolution() {
        Long tmp = maxResolution;
        if (null != tmp) return tmp;
        Class<ImageTransformationsTask> clazz = ImageTransformationsTask.class;
        synchronized (ImageTransformationsTask.class) {
            tmp = maxResolution;
            if (null != tmp) return tmp;
            int defaultValue = 12087962;
            ConfigurationService configService = Services.getService(ConfigurationService.class);
            if (null == configService) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultValue;
            }
            maxResolution = tmp = Long.valueOf(configService.getIntProperty("com.openexchange.tools.images.transformations.maxResolution", defaultValue));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private static IOException createResolutionExceededIOException(long maxResolution, int resolution) {
        return new ImageTransformationDeniedIOException("Image transformation denied. Resolution is too high. (current=" + resolution + ", max=" + maxResolution + ')');
    }

    private ImageTransformationsImpl(BufferedImage sourceImage, InputStream sourceImageStream, IFileHolder imageFile, Object optSource) {
        this.optSource = optSource;
        if (null == imageFile) {
            this.sourceImageStream = sourceImageStream;
            this.sourceImageFile = null;
        } else if (imageFile.repetitive()) {
            this.sourceImageStream = null;
            this.sourceImageFile = imageFile;
        } else {
            try {
                this.sourceImageStream = imageFile.getStream();
                this.sourceImageFile = null;
            }
            catch (OXException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        this.sourceImage = sourceImage;
        this.transformations = new ArrayList<ImageTransformation>();
        this.transformationContext = new TransformationContext();
    }

    public ImageTransformationsImpl(BufferedImage sourceImage, Object optSource) {
        this(sourceImage, null, null, optSource);
    }

    public ImageTransformationsImpl(InputStream sourceImageStream, Object optSource) {
        this(null, sourceImageStream, null, optSource);
    }

    public ImageTransformationsImpl(IFileHolder imageFile, Object optSource) {
        this(null, null, imageFile, optSource);
    }

    public ImageTransformations rotate() {
        this.transformations.add(RotateTransformation.getInstance());
        return this;
    }

    public ImageTransformations scale(int maxWidth, int maxHeight, ScaleType scaleType) {
        if (maxWidth > Constants.getMaxWidth()) {
            throw new IllegalArgumentException("Width " + maxWidth + " exceeds max. supported width " + Constants.getMaxWidth());
        }
        if (maxHeight > Constants.getMaxHeight()) {
            throw new IllegalArgumentException("Height " + maxHeight + " exceeds max. supported height " + Constants.getMaxHeight());
        }
        this.transformations.add(new ScaleTransformation(maxWidth, maxHeight, scaleType));
        return this;
    }

    public ImageTransformations crop(int x, int y, int width, int height) {
        this.transformations.add(new CropTransformation(x, y, width, height));
        return this;
    }

    public ImageTransformations compress() {
        this.compress = true;
        return this;
    }

    public BufferedImage getImage() throws IOException {
        if (!this.needsTransformation(null) && null != this.sourceImage) {
            return this.sourceImage;
        }
        return this.getImage(null, null);
    }

    public byte[] getBytes(String formatName) throws IOException {
        String imageFormat = ImageTransformationUtility.getImageFormat(formatName);
        return this.innerGetBytes(imageFormat);
    }

    private byte[] innerGetBytes(String imageFormat) throws IOException {
        return this.write(this.getImage(imageFormat, null), imageFormat);
    }

    public InputStream getInputStream(String formatName) throws IOException {
        byte[] bytes;
        String imageFormat = ImageTransformationUtility.getImageFormat(formatName);
        if (!this.needsTransformation(imageFormat)) {
            InputStream in = ImageTransformationsImpl.getFileStream(this.sourceImageFile);
            if (null != in) {
                return in;
            }
            in = this.sourceImageStream;
            if (null != in) {
                return in;
            }
        }
        return null == (bytes = this.innerGetBytes(imageFormat)) ? null : Streams.newByteArrayInputStream((byte[])bytes);
    }

    public BasicTransformedImage getTransformedImage(String formatName) throws IOException {
        String imageFormat = ImageTransformationUtility.getImageFormat(formatName);
        BufferedImage bufferedImage = this.getImage(imageFormat, null);
        return this.writeTransformedImage(bufferedImage, imageFormat);
    }

    public TransformedImage getFullTransformedImage(String formatName) throws IOException {
        String imageFormat = ImageTransformationUtility.getImageFormat(formatName);
        BufferedImage bufferedImage = this.getImage(imageFormat, null);
        return this.writeTransformedImage(bufferedImage, imageFormat);
    }

    private boolean needsTransformation(String formatName) {
        if (!ImageTransformationUtility.canRead(formatName)) {
            return false;
        }
        for (ImageTransformation transformation : this.transformations) {
            if (!transformation.supports(formatName)) continue;
            return true;
        }
        return false;
    }

    protected BufferedImage getImage(String formatName, ImageTransformationSignaler signaler) throws IOException {
        BufferedImage image = this.getSourceImage(formatName, signaler);
        if (null != image && image.getHeight() > 3 && image.getWidth() > 3) {
            ImageInformation imageInformation = null != this.metadata ? ImageTransformationUtility.getImageInformation(this.metadata) : null;
            for (ImageTransformation transformation : this.transformations) {
                if (!transformation.supports(formatName)) continue;
                image = transformation.perform(image, this.transformationContext, imageInformation);
            }
        }
        image = ImageTransformationsImpl.removeTransparencyIfNeeded(image, formatName);
        return image;
    }

    private BufferedImage getSourceImage(String formatName, ImageTransformationSignaler signaler) throws IOException {
        if (null == this.sourceImage) {
            if (null != this.sourceImageStream) {
                long maxResolution;
                long maxSize = ImageTransformationsImpl.maxSize();
                this.sourceImage = this.needsMetadata(formatName, maxSize, maxResolution = ImageTransformationsImpl.maxResolution()) ? this.readAndExtractMetadataFromStream(this.sourceImageStream, formatName, maxSize, maxResolution, signaler) : this.read(this.sourceImageStream, formatName, signaler);
            } else if (null != this.sourceImageFile) {
                long maxResolution;
                long maxSize = ImageTransformationsImpl.maxSize();
                this.sourceImage = this.needsMetadata(formatName, maxSize, maxResolution = ImageTransformationsImpl.maxResolution()) ? this.readAndExtractMetadataFromFile(this.sourceImageFile, formatName, maxSize, maxResolution, signaler) : this.read(ImageTransformationsImpl.getFileStream(this.sourceImageFile), formatName, signaler);
            }
        }
        return this.sourceImage;
    }

    private boolean needsMetadata(String formatName, long maxSize, long maxResolution) {
        if (maxSize > 0L || maxResolution > 0L) {
            return true;
        }
        if (null == formatName || 0 == formatName.length()) {
            return false;
        }
        for (ImageTransformation transformation : this.transformations) {
            if (!transformation.supports(formatName) || !transformation.needsImageInformation()) continue;
            return true;
        }
        return false;
    }

    private TransformedImage writeTransformedImage(BufferedImage image, String formatName) throws IOException {
        return new DefaultTransformedImageCreator().writeTransformedImage(image, formatName, this.transformationContext, this.needsCompression(formatName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] write(BufferedImage image, String formatName) throws IOException {
        byte[] byArray;
        if (null == image) {
            return null;
        }
        UnsynchronizedByteArrayOutputStream outputStream = null;
        try {
            outputStream = new UnsynchronizedByteArrayOutputStream(8192);
            if (this.needsCompression(formatName)) {
                ImageTransformationsImpl.writeCompressed(image, formatName, (OutputStream)outputStream, this.transformationContext);
            } else {
                ImageTransformationsImpl.write(image, formatName, (OutputStream)outputStream);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Streams.close(outputStream);
            throw throwable;
        }
        Streams.close((Closeable)outputStream);
        return byArray;
    }

    private boolean needsCompression(String formatName) {
        return this.compress && null != formatName && "jpeg".equalsIgnoreCase(formatName) || "jpg".equalsIgnoreCase(formatName);
    }

    private static void write(BufferedImage image, String formatName, OutputStream output) throws IOException {
        if (!ImageIO.write((RenderedImage)image, formatName, output)) {
            throw new IOException("no appropriate writer found for " + formatName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCompressed(BufferedImage image, String formatName, OutputStream output, TransformationContext transformationContext) throws IOException {
        ImageWriter writer = null;
        ImageInputStream imageOutputStream = null;
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
            if (!(null != iter && iter.hasNext() || null != (iter = ImageIO.getImageWritersByMIMEType(formatName)) && iter.hasNext())) {
                throw new IOException("No image writer for format " + formatName);
            }
            writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            ImageTransformationsImpl.adjustCompressionParams(iwp);
            imageOutputStream = ImageIO.createImageOutputStream(output);
            writer.setOutput(imageOutputStream);
            IIOImage iioImage = new IIOImage(image, null, null);
            writer.write(null, iioImage, iwp);
            transformationContext.addExpense(1);
        }
        finally {
            if (null != writer) {
                writer.dispose();
            }
            if (null != imageOutputStream) {
                imageOutputStream.close();
            }
        }
    }

    private static void adjustCompressionParams(ImageWriteParam parameters) {
        try {
            parameters.setCompressionMode(2);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("", (Throwable)e);
        }
        try {
            parameters.setProgressiveMode(1);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("", (Throwable)e);
        }
        try {
            parameters.setCompressionQuality(0.8f);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage read(InputStream inputStream, String formatName, ImageTransformationSignaler signaler) throws IOException {
        try {
            BufferedImage bufferedImage = this.imageIoRead(inputStream, signaler);
            return bufferedImage;
        }
        catch (RuntimeException e) {
            LOG.debug("error reading image from stream for {}", (Object)formatName, (Object)e);
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            Streams.close((Closeable)inputStream);
        }
    }

    private BufferedImage readAndExtractMetadataFromStream(InputStream inputStream, String formatName, long maxSize, long maxResolution, ImageTransformationSignaler signaler) throws IOException {
        ThresholdFileHolder sink = new ThresholdFileHolder();
        try {
            sink.write((InputStream)(maxSize > 0L ? new CountingInputStream(inputStream, maxSize, IMAGE_SIZE_EXCEEDED_EXCEPTION_CREATOR) : inputStream));
            BufferedImage bufferedImage = this.readAndExtractMetadataFromFile0(sink, formatName, maxResolution, signaler);
            return bufferedImage;
        }
        catch (OXException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Error accessing file holder", null == cause ? e : cause);
        }
        finally {
            Streams.close((Closeable)((Object)sink));
        }
    }

    private BufferedImage readAndExtractMetadataFromFile(IFileHolder imageFile, String formatName, long maxSize, long maxResolution, ImageTransformationSignaler signaler) throws IOException {
        if (maxSize > 0L && imageFile.getLength() > maxSize) {
            throw IMAGE_SIZE_EXCEEDED_EXCEPTION_CREATOR.createIOException(imageFile.getLength(), maxSize);
        }
        return this.readAndExtractMetadataFromFile0(imageFile, formatName, maxResolution, signaler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readAndExtractMetadataFromFile0(IFileHolder imageFile, String formatName, long maxResolution, ImageTransformationSignaler signaler) throws IOException {
        BufferedInputStream bufferedStream = ImageTransformationUtility.bufferedInputStreamFor(ImageTransformationsImpl.getFileStream(imageFile));
        try {
            int resolution;
            ImageInformation imageInformation;
            int magicNumber = ImageTransformationUtility.readMagicNumber(bufferedStream);
            boolean reset = false;
            try {
                if ((magicNumber & 0xFFD8) == 65496) {
                    bufferedStream.mark(65536);
                    reset = true;
                    this.metadata = JpegMetadataReader.readMetadata((InputStream)bufferedStream, (boolean)false);
                } else if (magicNumber != 18761) {
                    if (magicNumber == 19789) {
                    } else if (magicNumber == 14402) {
                        bufferedStream.mark(32);
                        reset = true;
                        this.metadata = PsdMetadataReader.readMetadata((InputStream)bufferedStream, (boolean)false);
                    }
                }
            }
            catch (ImageProcessingException e) {
                LOG.debug("Error getting metadata for {}", (Object)formatName, (Object)e);
            }
            finally {
                if (reset) {
                    try {
                        bufferedStream.reset();
                    }
                    catch (IOException e) {
                        LOG.debug("Error resetting image stream", (Throwable)e);
                        Streams.close((Closeable)bufferedStream);
                        bufferedStream = ImageTransformationUtility.bufferedInputStreamFor(ImageTransformationsImpl.getFileStream(imageFile));
                    }
                }
            }
            if (maxResolution > 0L && null != (imageInformation = ImageTransformationUtility.getImageInformation(this.metadata)) && (long)(resolution = imageInformation.height * imageInformation.width) > maxResolution) {
                throw ImageTransformationsImpl.createResolutionExceededIOException(maxResolution, resolution);
            }
            BufferedImage bufferedImage = this.imageIoRead(bufferedStream, signaler);
            return bufferedImage;
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Error reading image for {}", (Object)formatName, (Object)e);
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            Streams.close((Closeable)bufferedStream);
        }
    }

    private BufferedImage imageIoRead(InputStream in, ImageTransformationSignaler signaler) throws IOException {
        ImageTransformationsImpl.onImageRead(signaler);
        return ImageIO.read(in);
    }

    private static void onImageRead(ImageTransformationSignaler signaler) {
        if (null != signaler) {
            try {
                signaler.onImageRead();
            }
            catch (Exception e) {
                LOG.debug("Signaler could not be called", (Throwable)e);
            }
        }
    }

    private static BufferedImage removeTransparencyIfNeeded(BufferedImage image, String formatName) {
        ColorModel colorModel;
        if (null != image && null != formatName && !ImageTransformationUtility.supportsTransparency(formatName) && null != (colorModel = image.getColorModel()) && colorModel.hasAlpha()) {
            BufferedImage targetImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            Graphics2D graphics = targetImage.createGraphics();
            graphics.drawImage(image, 0, 0, Color.WHITE, null);
            graphics.dispose();
            return targetImage;
        }
        return image;
    }

    private static InputStream getFileStream(IFileHolder imageFile) throws IOException {
        if (null == imageFile) {
            return null;
        }
        try {
            return imageFile.getStream();
        }
        catch (OXException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw null == cause ? new IOException(e.getMessage(), e) : new IOException(cause.getMessage(), cause);
        }
    }

    static {
        ImageTransformationReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                waitTimeoutSeconds = null;
                maxSize = null;
                maxResolution = null;
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
        IMAGE_SIZE_EXCEEDED_EXCEPTION_CREATOR = new CountingInputStream.IOExceptionCreator(){

            public IOException createIOException(long total, long max) {
                if (total > 0L && max > 0L) {
                    return new ImageTransformationDeniedIOException("Image transformation denied. Size is too big. (current=" + total + ", max=" + max + ')');
                }
                return new ImageTransformationDeniedIOException("Image transformation denied. Size is too big.");
            }
        };
    }
}

