/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.imagetransformation.ImageInformation;
import com.openexchange.imagetransformation.ScaleType;
import com.openexchange.imagetransformation.Utility;
import com.openexchange.java.Streams;
import com.openexchange.tools.images.transformations.RotateTransformation;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTransformationUtility {
    private static final Logger LOG = LoggerFactory.getLogger(ImageTransformationUtility.class);
    private static final String COVER = ScaleType.COVER.getKeyword();

    private ImageTransformationUtility() {
    }

    public static boolean seemsLikeThumbnailRequest(AJAXRequestData requestData) {
        return COVER.equals(requestData.getParameter("scaleType")) || "thumbnail_image".equals(requestData.getFormat());
    }

    public static boolean seemsLikeThumbnailRequest(HttpServletRequest request) {
        return COVER.equals(request.getParameter("scaleType")) || "thumbnail_image".equals(request.getParameter("format"));
    }

    public static String getImageFormat(String value) {
        return Utility.getImageFormat((String)value);
    }

    public static boolean canRead(String formatName) {
        return Utility.canRead((String)formatName);
    }

    public static boolean supportsTransparency(String formatName) {
        return Utility.supportsTransparency((String)formatName);
    }

    public static BufferedInputStream bufferedInputStreamFor(InputStream in) {
        return Utility.bufferedInputStreamFor((InputStream)in);
    }

    public static InputStream markSupportingInputStreamFor(InputStream in) {
        return Utility.markSupportingInputStreamFor((InputStream)in);
    }

    public static int readMagicNumber(BufferedInputStream inputStream) throws IOException {
        return Utility.readMagicNumber((BufferedInputStream)inputStream);
    }

    public static ImageInformation getImageInformation(Metadata metadata) {
        if (null == metadata) {
            return null;
        }
        int orientation = 1;
        int width = 0;
        int height = 0;
        try {
            JpegDirectory jpegDirectory;
            Directory directory = metadata.getDirectory(ExifIFD0Directory.class);
            if (null != directory) {
                orientation = directory.getInt(274);
            }
            if (null != (jpegDirectory = (JpegDirectory)metadata.getDirectory(JpegDirectory.class))) {
                width = jpegDirectory.getImageWidth();
                height = jpegDirectory.getImageHeight();
            }
        }
        catch (MetadataException e) {
            LOG.debug("Unable to retrieve image information.", (Throwable)e);
            return null;
        }
        return new ImageInformation(orientation, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requiresRotateTransformation(InputStream in) throws IOException {
        if (null == in) {
            return false;
        }
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((BufferedInputStream)ImageTransformationUtility.bufferedInputStreamFor(in), (boolean)false);
            ImageInformation imageInformation = ImageTransformationUtility.getImageInformation(metadata);
            boolean bl = RotateTransformation.getInstance().needsRotation(imageInformation);
            return bl;
        }
        catch (ImageProcessingException e) {
            LOG.debug("error getting metadata.", (Throwable)e);
        }
        finally {
            Streams.close((Closeable)in);
        }
        return false;
    }
}

