/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools;

import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TimeZoneUtils {
    private static final ConcurrentMap<String, TimeZone> ZONE_CACHE = new ConcurrentHashMap<String, TimeZone>();

    private TimeZoneUtils() {
    }

    public static TimeZone getTimeZone(String ID) {
        TimeZone tmp;
        if (null == ID) {
            return (TimeZone)ZONE_CACHE.get("GMT");
        }
        TimeZone tz = (TimeZone)ZONE_CACHE.get(ID);
        if (tz == null && null == (tz = ZONE_CACHE.putIfAbsent(ID, tmp = TimeZone.getTimeZone(ID)))) {
            tz = tmp;
        }
        return tz;
    }

    public static long addTimeZoneOffset(long date, String timeZone) {
        return TimeZoneUtils.addTimeZoneOffset(date, TimeZoneUtils.getTimeZone(timeZone));
    }

    public static long addTimeZoneOffset(long date, TimeZone timeZone) {
        return date + (long)timeZone.getOffset(date);
    }
}

