/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.services;

import com.openexchange.exception.OXException;
import com.openexchange.session.Reply;
import com.openexchange.session.Session;
import com.openexchange.session.inspector.Reason;
import com.openexchange.session.inspector.SessionInspectorChain;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionInspector {
    private static final SessionInspectorChain NOOP_CHAIN = new SessionInspectorChain(){

        public Reply onSessionMiss(String sessionId, HttpServletRequest request, HttpServletResponse response) throws OXException {
            return Reply.CONTINUE;
        }

        public Reply onSessionHit(Session session, HttpServletRequest request, HttpServletResponse response) throws OXException {
            return Reply.CONTINUE;
        }

        public Reply onAutoLoginFailed(Reason reason, HttpServletRequest request, HttpServletResponse response) throws OXException {
            return Reply.CONTINUE;
        }

        public boolean isEmpty() {
            return true;
        }
    };
    private static final SessionInspector SINGLETON = new SessionInspector();
    private final AtomicReference<SessionInspectorChain> reference = new AtomicReference<SessionInspectorChain>(NOOP_CHAIN);

    public static SessionInspector getInstance() {
        return SINGLETON;
    }

    private SessionInspector() {
    }

    public SessionInspectorChain getChain() {
        return this.reference.get();
    }

    public boolean setService(SessionInspectorChain service) {
        return this.reference.compareAndSet(NOOP_CHAIN, service);
    }

    public boolean dropService(SessionInspectorChain service) {
        return this.reference.compareAndSet(service, NOOP_CHAIN);
    }
}

