/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.json.actions;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.resource.Resource;
import com.openexchange.resource.internal.ResourceServiceImpl;
import com.openexchange.resource.json.ResourceAJAXRequest;
import com.openexchange.resource.json.actions.AbstractResourceAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.PUT, name="list", description="List resources", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="An array with resources ids. ", responseDescription="An array of resource objects as described in Resource response.")
public final class ListAction
extends AbstractResourceAction {
    private static final Logger LOG = LoggerFactory.getLogger(ListAction.class);

    public ListAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(ResourceAJAXRequest req) throws OXException, JSONException {
        Date timestamp;
        UserStorage userStorage = null;
        JSONArray jsonArray = (JSONArray)req.getData();
        int len = jsonArray.length();
        LinkedList<Resource> resources = new LinkedList<Resource>();
        if (len > 0) {
            long lastModified = Long.MIN_VALUE;
            ServerSession session = req.getSession();
            for (int a = 0; a < len; ++a) {
                JSONObject jData = jsonArray.getJSONObject(a);
                int id = DataParser.checkInt(jData, "id");
                Resource r = null;
                try {
                    r = ResourceServiceImpl.getInstance().getResource(id, session.getContext());
                }
                catch (OXException exc) {
                    LOG.debug("resource not found try to find id in user table", (Throwable)exc);
                }
                if (r == null) {
                    if (userStorage == null) {
                        userStorage = UserStorage.getInstance();
                    }
                    User u = userStorage.getUser(id, session.getContext());
                    r = new Resource();
                    r.setIdentifier(u.getId());
                    r.setDisplayName(u.getDisplayName());
                    r.setLastModified(new Date(0L));
                }
                if (lastModified < r.getLastModified().getTime()) {
                    lastModified = r.getLastModified().getTime();
                }
                resources.add(r);
            }
            timestamp = new Date(lastModified);
        } else {
            timestamp = new Date(0L);
        }
        return new AJAXRequestResult(resources, timestamp, "resource");
    }
}

