/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.quota.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.quota.json.QuotaAJAXRequest;
import com.openexchange.quota.json.actions.AbstractQuotaAction;
import com.openexchange.server.ServiceLookup;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="mail", description="Get the mail usage data", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, responseDescription="A JSON Object containing the fields \"use\" and \"quota\". \"use\" represents the use mail quota and the field \"quota\" represents the maximum. -1 represents an unlimited quota.")
public final class MailAction
extends AbstractQuotaAction {
    private static final Logger LOG = LoggerFactory.getLogger(MailAction.class);

    public MailAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(QuotaAJAXRequest req) throws OXException, JSONException {
        MailServletInterface mi = null;
        try {
            Object quotaInfo = null;
            try {
                mi = MailServletInterface.getInstance(req.getSession());
                quotaInfo = mi.getQuotas(new int[]{1, 2});
            }
            catch (OXException e) {
                if (MailExceptionCode.ACCOUNT_DOES_NOT_EXIST.equals(e) || MimeMailExceptionCode.LOGIN_FAILED.equals(e)) {
                    LOG.debug("", (Throwable)e);
                } else {
                    LOG.error("", (Throwable)e);
                }
                quotaInfo = new long[][]{{-1L, -1L}, {-1L, -1L}};
            }
            JSONObject data = new JSONObject();
            data.put("quota", quotaInfo[0][0] << 10);
            data.put("use", quotaInfo[0][1] << 10);
            data.put("countquota", quotaInfo[1][0]);
            data.put("countuse", quotaInfo[1][1]);
            AJAXRequestResult aJAXRequestResult = new AJAXRequestResult((Object)data, "json");
            return aJAXRequestResult;
        }
        finally {
            try {
                if (mi != null) {
                    mi.close(false);
                }
            }
            catch (OXException e) {}
        }
    }
}

