/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.passwordchange;

import com.openexchange.capabilities.CapabilityChecker;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.Permission;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Strings;
import com.openexchange.passwordchange.PasswordChangeService;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.userconf.UserPermissionService;
import org.apache.commons.lang.Validate;

public class EditPasswordCapabilityChecker
implements CapabilityChecker {
    public static final String EDIT_PASSWORD_CAP = "edit_password";
    private ServiceLookup serviceLookup;

    public EditPasswordCapabilityChecker(ServiceLookup serviceLookup) {
        Validate.notNull((Object)serviceLookup);
        this.serviceLookup = serviceLookup;
    }

    public boolean isEnabled(String capability, Session ses) throws OXException {
        if (EDIT_PASSWORD_CAP.equals(capability)) {
            if (Strings.isEmpty((String)capability) || ses == null) {
                return false;
            }
            ServerSession session = ServerSessionAdapter.valueOf(ses);
            if (session == null || session.isAnonymous()) {
                return false;
            }
            int contextId = session.getContextId();
            int userId = session.getUserId();
            if (contextId > 0 && userId > 0) {
                User user = session.getUser();
                if (user != null && user.isGuest()) {
                    if (Strings.isNotEmpty((String)user.getMail())) {
                        return true;
                    }
                } else {
                    UserPermissionBits userPermissionBits;
                    UserPermissionService userPermissionService;
                    PasswordChangeService optionalService = (PasswordChangeService)this.serviceLookup.getOptionalService(PasswordChangeService.class);
                    if (optionalService != null && (userPermissionService = (UserPermissionService)this.serviceLookup.getService(UserPermissionService.class)) != null && (userPermissionBits = userPermissionService.getUserPermissionBits(userId, session.getContext())) != null) {
                        return userPermissionBits.hasPermission(Permission.EDIT_PASSWORD);
                    }
                }
            }
        }
        return false;
    }

    public static Class<?>[] getNeededServices() {
        return new Class[]{UserPermissionService.class};
    }
}

